/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.plugin.frame.Editor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class MacroRunner
implements Runnable {
    private String macro;
    private Program pgm;
    private int address;
    private String name;
    private Thread thread;
    private String argument;
    private Editor editor;

    public MacroRunner() {
    }

    public MacroRunner(String string) {
        this(string, (Editor)null);
    }

    public MacroRunner(String string, Editor editor) {
        this.macro = string;
        this.editor = editor;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(String string, String string2) {
        this.macro = string;
        this.argument = string2;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(File file) {
        int n = (int)file.length();
        if (n <= 0) {
            return;
        }
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
            this.macro = new String(stringBuffer);
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return;
        }
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(Program program, int n, String string) {
        this(program, n, string, (String)null);
    }

    public MacroRunner(Program program, int n, String string, String string2) {
        this.pgm = program;
        this.address = n;
        this.name = string;
        this.argument = string2;
        this.thread = new Thread((Runnable)this, string + "_Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(Program program, int n, String string, Editor editor) {
        this.pgm = program;
        this.address = n;
        this.name = string;
        this.editor = editor;
        this.thread = new Thread((Runnable)this, string + "_Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void runShortcut(Program program, int n, String string) {
        this.pgm = program;
        this.address = n;
        this.name = string;
        if (program.queueCommands) {
            this.run();
        } else {
            this.thread = new Thread((Runnable)this, string + "_Macro$");
            this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
            this.thread.start();
        }
    }

    public void run() {
        Interpreter interpreter = new Interpreter();
        interpreter.argument = this.argument;
        if (this.editor != null) {
            interpreter.setEditor(this.editor);
        }
        try {
            if (this.pgm == null) {
                interpreter.run(this.macro);
            } else {
                interpreter.runMacro(this.pgm, this.address, this.name);
            }
        }
        catch (Throwable throwable) {
            interpreter.abortMacro();
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.unlock();
            }
            String string = throwable.getMessage();
            if (throwable instanceof RuntimeException && string != null && throwable.getMessage().equals("Macro canceled")) {
                return;
            }
            IJ.handleException(throwable);
        }
    }
}

