% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directives.R
\name{directives}
\alias{directives}
\title{Inno Setup Preprocessor (ISPP) Directives}
\usage{
directives(app_name, include_R = FALSE, R_version = paste0(R.version$major,
  ".", R.version$minor), include_Pandoc = FALSE,
  Pandoc_version = rmarkdown::pandoc_version(), include_Chrome = FALSE,
  app_version = "0.0.0", publisher = "", main_url = "",
  custom_vars = "", custom_values = "")
}
\arguments{
\item{app_name}{The name of the app being installed. It will be displayed throughout the installer's window titles, wizard pages, and dialog boxes. See \href{http://www.jrsoftware.org/ishelp/topic_setup_appname.htm}{[Setup]:AppName} for details. For continuous installations, \code{app_name} is used to check for an R package of the same name, and update it. The Continuous Installation vignette has more details.}

\item{include_R}{To include R in the installer, \code{include_R = TRUE}. This will include the version of R specified by \code{R_version} in your installer. The installer will check each user's registry for that version of R, and only install it if necessary.}

\item{R_version}{R version to use, defaults to: \code{paste0(R.version$major, '.', R.version$minor)}.}

\item{include_Pandoc}{To include Pandoc in the installer, \code{include_Pandoc = TRUE}. If installing a flexdashboard app, some users may need a copy of Pandoc. Similar to including R, the installer will check the user's registry for the version of Pandoc returned by \code{\link[rmarkdown]{pandoc_version}} and only install it if necessary.}

\item{Pandoc_version}{Pandoc version to use, defaults to: \code{\link[rmarkdown]{pandoc_version}}.}

\item{include_Chrome}{To include Chrome in the installer, \code{include_Chrome = TRUE}. If you would like to use Chrome's app mode, this option includes a copy of Chrome for users that do not have it installed yet.}

\item{app_version}{Version number of the app being installed, defaults to \code{'0.0.0'}. It is displayed in the Version field of the app's \emph{Add/Remove Programs} entry. See \href{http://www.jrsoftware.org/ishelp/index.php?topic=setup_appversion}{[Setup]:AppVersion} for details.}

\item{publisher}{String displayed on the "Support" dialogue of the \emph{Add/Remove Programs} Control Panel applet, defaults to " ". See \href{http://www.jrsoftware.org/ishelp/index.php?topic=setup_apppublisher}{[Setup]:AppPublisher} for details.}

\item{main_url}{String. Defaults to "".}

\item{custom_vars}{String vector. Defaults to "", and must be the same length as \code{custom_values}.}

\item{custom_values}{String vector of values for \code{custom_vars}. Defaults to "", and must be the same length as \code{custom_vars}.}
}
\value{
Chainable character vector, which can be used as the \code{text} argument of \code{\link{writeLines}} to generate an ISS.
}
\description{
Sets ISPP directives at the top of an ISS.
}
\details{
ISPP directives automate compile-time tasks and decrease the probability
of typos. When referring to an ISPP directive, use
'\{#var_name\}'. For more information, call \code{ispp_doc()} or visit
\href{http://www.jrsoftware.org/ispphelp/topic_directives.htm}{ISPP Help}.

\code{custom_vars} and \code{custom_values} utilize the #define directive.
}
\examples{
\dontrun{
start_iss('myapp') \%>\%
  directives(include_R = FALSE, R_version = '3.3.2',
    custom_vars = 'helpers', custom_values = 'path\\\\to\\\\helpers') \%>\%
  files(app_dir = getwd(),
    file_list = '{#helpers}')
}

}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives}}, \code{\link{setup}}, \code{\link{languages}}, \code{\link{tasks}}, \code{\link{files}}, \code{\link{icons}}, \code{\link{run}}, and \code{\link{code}}.
}
\author{
Jonathan M. Hill
}
