% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directives_section.R
\name{directives_section}
\alias{directives_section}
\title{Inno Setup Preprocessor (ISPP) Directives}
\usage{
directives_section(app_name, include_R = FALSE,
  R_version = paste0(R.version$major, ".", R.version$minor),
  include_Pandoc = FALSE, Pandoc_version = rmarkdown::pandoc_version(),
  include_Chrome = FALSE, include_Rtools = FALSE,
  Rtools_version = "3.5", app_version = "0.0.0", publisher = "",
  main_url = "", custom_vars = "", custom_values = "")
}
\arguments{
\item{app_name}{The name of the app. It will be displayed throughout the installer's window titles, wizard pages, and dialog boxes. See \href{http://www.jrsoftware.org/ishelp/topic_setup_appname.htm}{[Setup]:AppName} for details. For continuous installations, \code{app_name} is used to check for an R package of the same name, and update it. The Continuous Installation vignette has more details.}

\item{include_R}{To include R in the installer, \code{include_R = TRUE}. The version of R specified by \code{R_version} is used. The installer will check each user's registry and only install R if necessary.}

\item{R_version}{R version to use. Supports inequalities. Defaults to: \code{paste0(">=", R.version$major, '.', R.version$minor)}.}

\item{include_Pandoc}{To include Pandoc in the installer, \code{include_Pandoc = TRUE}. If installing a flexdashboard app, some users may need a copy of Pandoc. The installer will check the user's registry for the version of Pandoc specified in \code{Pandoc_version} and only install it if necessary.}

\item{Pandoc_version}{Pandoc version to use, defaults to: \link[rmarkdown]{pandoc_available}.}

\item{include_Chrome}{To include Chrome in the installer, \code{include_Chrome = TRUE}. If you would like to use Chrome's app mode, it is no longer supported by Google :(.}

\item{include_Rtools}{To include Rtools in the installer, \code{include_Rtools = TRUE}. For some packages to build properly, you may need to include Rtools.}

\item{Rtools_version}{Rtools version to include. For more information, see \href{https://cran.r-project.org/bin/windows/Rtools/}{Building R for Windows}.}

\item{app_version}{Version number of the app being installed, defaults to \code{'0.0.0'}. It is displayed in the Version field of the app's \emph{Add/Remove Programs} entry. See \href{http://www.jrsoftware.org/ishelp/index.php?topic=setup_appversion}{[Setup]:AppVersion} for details.}

\item{publisher}{String displayed on the "Support" dialogue of the \emph{Add/Remove Programs} Control Panel applet, defaults to " ". See \href{http://www.jrsoftware.org/ishelp/index.php?topic=setup_apppublisher}{[Setup]:AppPublisher} for details.}

\item{main_url}{String. Defaults to "".}

\item{custom_vars}{String vector. Defaults to "", and must be the same length as \code{custom_values}.}

\item{custom_values}{String vector of values for \code{custom_vars}. Defaults to "", and must be the same length as \code{custom_vars}.}
}
\value{
Chainable character vector, which can be used as the \code{text} argument of \code{\link{writeLines}} to generate an ISS.
}
\description{
Sets ISPP directives at the top of an ISS.
}
\details{
ISPP directives automate compile-time tasks and decrease the probability
of typos. When referring to an ISPP directive, use
'\{#var_name\}'. For more information, call \code{ispp_doc()} or visit
\href{http://www.jrsoftware.org/ispphelp/topic_directives.htm}{ISPP Help}.

\code{custom_vars} and \code{custom_values} utilize the #define directive.
}
\examples{
\dontrun{
start_iss('myapp') \%>\%
  directives_section(
    include_R = FALSE, R_version = '3.3.2',
    custom_vars = 'helpers',
    custom_values = 'path\\\\to\\\\helpers') \%>\%
  files_section(
    app_dir = getwd(),
    file_list = '{#helpers}')
}

}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives_section}}, \code{\link{setup_section}}, \code{\link{languages_section}}, \code{\link{tasks_section}}, \code{\link{files_section}}, \code{\link{icons_section}}, \code{\link{run_section}}, and \code{\link{code_section}}.
}
\author{
Jonathan M. Hill
}
