/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.file;

import demetra.workspace.WorkspaceFamily;
import demetra.workspace.file.Index;
import demetra.workspace.file.Indexer;
import demetra.workspace.file.xml.XmlGenericWorkspace;
import demetra.workspace.file.xml.XmlGenericWorkspaceItem;
import demetra.workspace.io.JaxbUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

final class GenericIndexer
implements Indexer {
    private final Path file;
    private final Path rootFolder;
    private static final JAXBContext XML_GENERIC_WS_CONTEXT = JaxbUtil.createContext(XmlGenericWorkspace.class);
    private static final Index.Key SINGLE_CAL_GENERIC_KEY = new Index.Key(WorkspaceFamily.UTIL_CAL, "Calendars");
    private static final Index.Value SINGLE_CAL_GENERIC_VALUE = new Index.Value("Calendars", false, null);

    static boolean isValid(Path file) throws IOException {
        try {
            GenericIndexer.unmarshalIndex(file);
            return true;
        }
        catch (JAXBException ex) {
            return false;
        }
    }

    GenericIndexer(Path file, Path rootFolder) {
        this.file = file;
        this.rootFolder = rootFolder;
    }

    @Override
    public void checkId(Index.Key key) throws IOException {
        if (WorkspaceFamily.UTIL_CAL.equals((Object)key.getFamily()) && !key.getId().equals("Calendars")) {
            throw new IOException("Only one calendar file is allowed");
        }
    }

    @Override
    public Index loadIndex() throws IOException {
        try {
            return GenericIndexer.xmlToIndex(GenericIndexer.unmarshalIndex(this.file), this.rootFolder);
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void storeIndex(Index index) throws IOException {
        try {
            GenericIndexer.marshalIndex(this.file, GenericIndexer.indexToXml(index, this.rootFolder));
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
    }

    private static Index xmlToIndex(XmlGenericWorkspace xml, Path rootFolder) {
        Index.Builder result = Index.builder().name(xml.name);
        JaxbUtil.forEach(xml.items, o -> result.item(GenericIndexer.getIndexKey(o), GenericIndexer.getIndexValue(o)));
        GenericIndexer.pushCalendar(rootFolder, result);
        return result.build();
    }

    private static Index.Key getIndexKey(XmlGenericWorkspaceItem xml) {
        return new Index.Key(WorkspaceFamily.parse(xml.family), xml.file);
    }

    private static Index.Value getIndexValue(XmlGenericWorkspaceItem xml) {
        return new Index.Value(xml.name, xml.readOnly, xml.comments);
    }

    private static XmlGenericWorkspace indexToXml(Index index, Path rootFolder) {
        XmlGenericWorkspace result = new XmlGenericWorkspace();
        result.name = index.getName();
        result.items = GenericIndexer.indexEntriesToXml(GenericIndexer.pullCalendar(rootFolder, index).getItems());
        return result;
    }

    private static XmlGenericWorkspaceItem[] indexEntriesToXml(Map<Index.Key, Index.Value> entries) {
        return (XmlGenericWorkspaceItem[])entries.entrySet().stream().map(o -> {
            XmlGenericWorkspaceItem xml = new XmlGenericWorkspaceItem();
            xml.family = ((Index.Key)o.getKey()).getFamily().toString();
            xml.file = ((Index.Key)o.getKey()).getId();
            xml.name = ((Index.Value)o.getValue()).getLabel();
            xml.readOnly = ((Index.Value)o.getValue()).isReadOnly();
            xml.comments = ((Index.Value)o.getValue()).getComments();
            return xml;
        }).toArray(XmlGenericWorkspaceItem[]::new);
    }

    private static XmlGenericWorkspace unmarshalIndex(Path file) throws JAXBException, IOException {
        return (XmlGenericWorkspace)JaxbUtil.unmarshal(file, XML_GENERIC_WS_CONTEXT);
    }

    private static void marshalIndex(Path file, XmlGenericWorkspace jaxbElement) throws JAXBException, IOException {
        JaxbUtil.marshal(file, XML_GENERIC_WS_CONTEXT, jaxbElement, true);
    }

    private static void pushCalendar(Path rootFolder, Index.Builder index) {
        Path calFile = rootFolder.resolve("Calendars").resolve("Calendars.xml");
        if (Files.exists(calFile, new LinkOption[0]) && !Files.isDirectory(calFile, new LinkOption[0])) {
            index.item(SINGLE_CAL_GENERIC_KEY, SINGLE_CAL_GENERIC_VALUE);
        }
    }

    private static Index pullCalendar(Path rootFolder, Index index) {
        return index.withoutItem(SINGLE_CAL_GENERIC_KEY);
    }
}

