/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.file;

import demetra.workspace.Workspace;
import demetra.workspace.WorkspaceItem;
import demetra.workspace.file.FamilyHandler;
import demetra.workspace.file.FileFormat;
import demetra.workspace.file.FileWorkspaceImpl;
import demetra.workspace.io.IoUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface FileWorkspace
extends Workspace {
    @Nonnull
    public FileFormat getFileFormat() throws IOException;

    @Nonnull
    public Path getFile() throws IOException;

    @Nonnull
    public Path getRootFolder() throws IOException;

    @Nonnull
    public Path getFile(@Nonnull WorkspaceItem var1) throws IOException;

    @Nonnull
    public static FileWorkspace create(@Nonnull Path file, @Nonnull FileFormat format) throws IOException {
        return FileWorkspaceImpl.create(file, format, IoUtil.supplierOfServiceLoader(FamilyHandler.class));
    }

    @Nonnull
    public static FileWorkspace open(@Nonnull Path file) throws IOException {
        return FileWorkspace.open(file, FileWorkspace.probeFormat(file).orElseThrow(() -> new IOException("Cannot probe workspace file format of '" + file + "'")));
    }

    @Nonnull
    public static FileWorkspace open(@Nonnull Path file, @Nonnull FileFormat format) throws IOException {
        return FileWorkspaceImpl.open(file, format, IoUtil.supplierOfServiceLoader(FamilyHandler.class));
    }

    @Nonnull
    public static Optional<FileFormat> probeFormat(@Nonnull Path file) throws IOException {
        return FileWorkspaceImpl.probeFormat(file);
    }
}

