/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.nonlinear;

import ec.benchmarking.ssf.SsfDisaggregation;
import ec.benchmarking.ssf.nonlinear.AbstractLinearizedDisaggregationAlgorithm;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfRefData;
import ec.tstoolkit.ssf.extended.INonLinearSsf;

public abstract class AbstractLinearizedDisaggregationSmoother<S extends INonLinearSsf, T extends ISsf>
extends AbstractLinearizedDisaggregationAlgorithm<S, T> {
    private boolean dsmoother_ = true;

    protected AbstractLinearizedDisaggregationSmoother(DataBlock y, int conv, S nlssf) {
        super(y, conv, nlssf);
    }

    @Override
    protected DataBlockStorage iterate() {
        SsfDisaggregation<ISsf> disagg = new SsfDisaggregation<ISsf>(this.conversion, this.m_lssf);
        SsfRefData data = new SsfRefData(this.getModifiedObservations(), null);
        if (this.dsmoother_) {
            DisturbanceSmoother dsmoother = new DisturbanceSmoother();
            dsmoother.setSsf(disagg);
            if (!dsmoother.process(data)) {
                return null;
            }
            SmoothingResults srslts = dsmoother.calcSmoothedStates();
            return srslts.getSmoothedStates();
        }
        Smoother smoother = new Smoother();
        smoother.setSsf(disagg);
        SmoothingResults srslts = new SmoothingResults(true, false);
        smoother.process(data, srslts);
        return srslts.getSmoothedStates();
    }
}

