/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.AbsMeanNormalizer;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.InPlaceNormalizer;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class MatrixNormalizer {
    private final InPlaceNormalizer normalizer;
    private double[] factors;

    public MatrixNormalizer() {
        this(new AbsMeanNormalizer());
    }

    public MatrixNormalizer(InPlaceNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void normalize(SubMatrix m) {
        this.factors = null;
        if (m == null || m.isEmpty()) {
            return;
        }
        this.factors = new double[m.getColumnsCount()];
        DataBlockIterator columns = m.columns();
        DataBlock col = columns.getData();
        int i = 0;
        do {
            this.factors[i++] = this.normalizer.normalize(col);
        } while (columns.next());
    }

    public IReadDataBlock getFactors() {
        return new ReadDataBlock(this.factors);
    }
}

