/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.ssf.ISsfData;

public class SsfDataWindow
implements ISsfData {
    private final ISsfData data_;
    private final double[] s_start_;
    private final int start_;
    private final int n_;

    public SsfDataWindow(ISsfData data, double[] state, int start, int length) {
        this.data_ = data;
        this.s_start_ = state;
        this.start_ = start;
        this.n_ = length >= 0 ? length : data.getCount() - start;
    }

    @Override
    public double get(int n) {
        return this.data_.get(n + this.start_);
    }

    @Override
    public int getCount() {
        return this.n_;
    }

    @Override
    public double[] getInitialState() {
        return this.s_start_;
    }

    @Override
    public int getObsCount() {
        int nobs = 0;
        for (int i = 0; i < this.n_; ++i) {
            if (this.data_.isMissing(this.start_ + i)) continue;
            ++nobs;
        }
        return nobs;
    }

    @Override
    public boolean hasData() {
        return this.data_.hasData();
    }

    @Override
    public boolean hasMissingValues() {
        return this.data_.hasMissingValues();
    }

    @Override
    public boolean isMissing(int pos) {
        return pos < 0 || pos >= this.n_ || this.data_.isMissing(pos + this.start_);
    }
}

