/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;

public class TransformedFunction
implements IFunction {
    private final ITransformation t_;
    private final IFunction f_;

    public static ITransformation linearTransformation(final double a, final double b) {
        return new ITransformation(){

            @Override
            public double f(double x) {
                return a + b * x;
            }

            @Override
            public double df(double x) {
                return b;
            }

            @Override
            public double d2f(double x) {
                return 0.0;
            }
        };
    }

    public TransformedFunction(IFunction fn, ITransformation t) {
        this.f_ = fn;
        this.t_ = t;
    }

    @Override
    public IFunctionInstance evaluate(IReadDataBlock parameters) {
        return new Instance(this.f_.evaluate(parameters));
    }

    @Override
    public IFunctionDerivatives getDerivatives(IFunctionInstance point) {
        return new Derivatives(this.f_.getDerivatives(point), point);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.f_.getDomain();
    }

    public static interface ITransformation {
        public double f(double var1);

        public double df(double var1);

        public double d2f(double var1);
    }

    class Derivatives
    implements IFunctionDerivatives {
        private final IFunctionDerivatives dfx_;
        private final IFunctionInstance p_;
        private final double fx_;

        Derivatives(IFunctionDerivatives dfx, IFunctionInstance p) {
            this.dfx_ = dfx;
            this.p_ = p;
            this.fx_ = p.getValue();
        }

        @Override
        public double[] getGradient() {
            double[] g = (double[])this.dfx_.getGradient().clone();
            double dt = TransformedFunction.this.t_.df(this.fx_);
            int i = 0;
            while (i < g.length) {
                int n = i++;
                g[n] = g[n] * dt;
            }
            return g;
        }

        @Override
        public Matrix getHessian() {
            Matrix h = this.dfx_.getHessian().clone();
            double[] g = this.dfx_.getGradient();
            double dt = TransformedFunction.this.t_.df(this.fx_);
            double d2t = TransformedFunction.this.t_.d2f(this.fx_);
            h.mul(dt);
            if (d2t != 0.0) {
                for (int i = 0; i < g.length; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        h.add(i, j, g[i] * g[j] * d2t);
                    }
                }
            }
            SymmetricMatrix.fromLower(h);
            return h;
        }
    }

    class Instance
    implements IFunctionInstance {
        private final IFunctionInstance fx_;

        Instance(IFunctionInstance fx) {
            this.fx_ = fx;
        }

        @Override
        public IReadDataBlock getParameters() {
            return this.fx_.getParameters();
        }

        @Override
        public double getValue() {
            return TransformedFunction.this.t_.f(this.fx_.getValue());
        }
    }
}

