/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.util;

import java.io.File;
import java.io.IOException;

public final class Paths {
    private Paths() {
    }

    public static String changeExtension(String file, String next) {
        int ipos;
        for (ipos = file.length() - 1; ipos >= 0 && file.charAt(ipos) != '.' && file.charAt(ipos) != File.separatorChar && file.charAt(ipos) != File.pathSeparatorChar; --ipos) {
        }
        String sfile = null;
        sfile = ipos < 0 || file.charAt(ipos) != '.' ? file : file.substring(0, ipos);
        if (next == null) {
            return sfile;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(sfile);
        builder.append('.');
        builder.append(next);
        return builder.toString();
    }

    public static String addExtension(String file, String ext) {
        StringBuilder builder = new StringBuilder();
        builder.append(file);
        builder.append('.');
        builder.append(ext);
        return builder.toString();
    }

    public static String[] splitFile(String file) {
        int ipos;
        String[] rslt = new String[3];
        for (ipos = file.length() - 1; ipos >= 0 && file.charAt(ipos) != '.' && file.charAt(ipos) != File.separatorChar; --ipos) {
        }
        if (ipos > 0 && file.charAt(ipos) == '.') {
            rslt[2] = file.substring(ipos + 1);
        }
        if (ipos < 0) {
            rslt[1] = file;
            return rslt;
        }
        int epos = ipos--;
        while (ipos >= 0 && file.charAt(ipos) != File.separatorChar) {
            --ipos;
        }
        if (ipos > 0) {
            rslt[0] = file.substring(0, ipos);
            if (ipos + 1 < epos) {
                rslt[1] = file.substring(ipos + 1, epos);
            } else {
                rslt[1] = rslt[2];
                rslt[2] = null;
            }
        } else {
            rslt[1] = file.substring(0, epos);
        }
        return rslt;
    }

    public static String getBaseName(String file) {
        String[] s = Paths.splitFile(file);
        return s[1];
    }

    public static String getFullPath(String file) {
        try {
            File tmp = new File(file);
            return Paths.splitFile(tmp.getCanonicalPath())[0];
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String concatenate(String root, String folder) {
        StringBuilder builder = new StringBuilder();
        if (root != null) {
            builder.append(root);
            if (root.charAt(root.length() - 1) != File.separatorChar && folder != null) {
                builder.append(File.separatorChar);
            }
        }
        if (folder != null) {
            builder.append(folder);
        }
        return builder.toString();
    }

    public static String getDefaultHome() {
        String parent = System.getenv("HOMESHARE");
        if (parent != null) {
            return parent;
        }
        parent = System.getenv("USERPROFILE");
        if (parent != null) {
            return parent;
        }
        return ".";
    }
}

