/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.multivariate;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.multivariate.IMSsfData;

public class MultivariateSsfData
implements IMSsfData,
Cloneable {
    private int c_;
    private int ncnt_;
    private Matrix x_;

    public MultivariateSsfData(Matrix m, int conv, int nconstraints) {
        this.x_ = m;
        this.c_ = conv;
        this.ncnt_ = nconstraints;
    }

    public MultivariateSsfData(MultivariateSsfData data) {
        this.c_ = data.c_;
        this.ncnt_ = data.ncnt_;
        this.x_ = data.x_;
    }

    public Object clone() {
        return new MultivariateSsfData(this);
    }

    @Override
    public int count(int v) {
        return this.c_ * this.x_.getRowsCount();
    }

    @Override
    public double get(int v, int pos) {
        if (v < this.x_.getColumnsCount()) {
            if ((pos + 1) % this.c_ != 0) {
                return Double.NaN;
            }
            return this.x_.get(pos / this.c_, v);
        }
        return 0.0;
    }

    @Override
    public double[] getInitialState() {
        return null;
    }

    @Override
    public int getVarsCount() {
        return this.x_.getColumnsCount() + this.ncnt_;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public boolean isMissing(int v, int pos) {
        return v < this.x_.getColumnsCount() && ((pos /= this.c_) >= this.x_.getRowsCount() || Double.isNaN(this.x_.get(pos, v)));
    }

    @Override
    public int obsCount(int v) {
        if (v < this.x_.getColumnsCount()) {
            int n = 0;
            DataBlock col = this.x_.column(v);
            for (int i = 0; i < col.getLength(); ++i) {
                if (Double.isNaN(col.get(i))) continue;
                ++n;
            }
            return n;
        }
        return this.count(v);
    }
}

