/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.design.Internal;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.ObsList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Arrays;
import java.util.Date;
import java.util.function.IntToDoubleFunction;

public class TsDataCollector {
    private final ObsList.LongObsList m_obs = ObsList.newLongObsList(false, TsPeriod.CalendarUtil.getInstance()::calcTsPeriodId);
    private double missing = -99999.0;

    public void addMissingValue(Date date) {
        this.m_obs.add(date.getTime(), Double.NaN);
    }

    public void addObservation(Date date, double value) {
        if (Double.isNaN(value) || value == this.missing) {
            this.m_obs.add(date.getTime(), Double.NaN);
        } else {
            this.m_obs.add(date.getTime(), value);
        }
    }

    public void clear() {
        this.m_obs.clear();
    }

    public double[] data() {
        this.m_obs.sortByPeriod();
        return this.m_obs.getValues();
    }

    public int getCount() {
        return this.m_obs.size();
    }

    public double getMissingValue() {
        return this.missing;
    }

    public void setMissingValue(double value) {
        this.missing = value;
    }

    public TsData make(TsFrequency frequency, TsAggregationType convMode) {
        if (frequency == TsFrequency.Undefined) {
            if (convMode != TsAggregationType.None) {
                throw new TsException("Invalid aggregation mode");
            }
            return TsDataCollector.makeFromUnknownFrequency(this.m_obs);
        }
        if (convMode != TsAggregationType.None) {
            return TsDataCollector.makeWithAggregation(this.m_obs, frequency, convMode);
        }
        return TsDataCollector.makeWithoutAggregation(this.m_obs, frequency);
    }

    @Internal
    public static TsData makeWithAggregation(ObsList obs, TsFrequency freq, TsAggregationType convMode) {
        int n = obs.size();
        if (n == 0) {
            return null;
        }
        obs.sortByPeriod();
        double[] vals = new double[n];
        int[] ids = new int[n];
        int ncur = -1;
        int avn = 0;
        block8: for (int i = 0; i < n; ++i) {
            int curid = obs.getPeriodId(freq, i);
            double value = obs.getValue(i);
            switch (convMode) {
                case Average: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        if (ncur >= 0) {
                            int n2 = ncur;
                            vals[n2] = vals[n2] / (double)avn;
                        }
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        avn = 1;
                        continue block8;
                    }
                    int n3 = ncur;
                    vals[n3] = vals[n3] + value;
                    ++avn;
                    continue block8;
                }
                case Sum: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        continue block8;
                    }
                    int n4 = ncur;
                    vals[n4] = vals[n4] + value;
                    continue block8;
                }
                case First: {
                    if (!Double.isFinite(value) || !TsDataCollector.isNewPeriod(ncur, curid, ids)) continue block8;
                    vals[++ncur] = value;
                    ids[ncur] = curid;
                    continue block8;
                }
                case Last: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        ids[++ncur] = curid;
                    }
                    vals[ncur] = value;
                    continue block8;
                }
                case Max: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        continue block8;
                    }
                    double dcur = value;
                    if (!(dcur > vals[ncur])) continue block8;
                    vals[ncur] = dcur;
                    continue block8;
                }
                case Min: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        continue block8;
                    }
                    double dcur = value;
                    if (!(dcur < vals[ncur])) continue block8;
                    vals[ncur] = dcur;
                }
            }
        }
        if (convMode == TsAggregationType.Average && ncur >= 0) {
            int n5 = ncur;
            vals[n5] = vals[n5] / (double)avn;
        }
        int firstId = ids[0];
        int lastId = ids[ncur];
        TsPeriod start = new TsPeriod(freq, firstId);
        int l = lastId - firstId + 1;
        if (l == ncur + 1) {
            return new TsData(start, ncur + 1 == n ? vals : Arrays.copyOf(vals, ncur + 1), false);
        }
        return new TsData(start, TsDataCollector.expand(ncur + 1, l, ids, o -> vals[o]), false);
    }

    private static boolean isNewPeriod(int ncur, int curid, int[] ids) {
        return ncur < 0 || curid != ids[ncur];
    }

    @Internal
    public static TsData makeFromUnknownFrequency(ObsList obs) {
        int s;
        int n = obs.size();
        if (n < 2) {
            return null;
        }
        obs.sortByPeriod();
        int[] ids = new int[n];
        TsFrequency[] freqs = TsFrequency.allFreqs;
        for (s = 0; s < freqs.length && !TsDataCollector.makeIdsFromFrequency(obs, freqs[s], ids); ++s) {
        }
        if (s == freqs.length) {
            return null;
        }
        int firstId = ids[0];
        int lastId = ids[n - 1];
        TsPeriod start = new TsPeriod(freqs[s], firstId);
        int l = lastId - firstId + 1;
        if (l == n) {
            return new TsData(start, obs.getValues(), false);
        }
        return new TsData(start, TsDataCollector.expand(n, l, ids, obs::getValue), false);
    }

    private static boolean makeIdsFromFrequency(ObsList obs, TsFrequency frequency, int[] ids) {
        ids[0] = obs.getPeriodId(frequency, 0);
        for (int i = 1; i < ids.length; ++i) {
            ids[i] = obs.getPeriodId(frequency, i);
            if (ids[i] != ids[i - 1]) continue;
            return false;
        }
        return true;
    }

    @Internal
    public static TsData makeWithoutAggregation(ObsList obs, TsFrequency freq) {
        int n = obs.size();
        if (n == 0) {
            return null;
        }
        obs.sortByPeriod();
        int[] ids = new int[n];
        ids[0] = obs.getPeriodId(freq, 0);
        for (int i = 1; i < n; ++i) {
            ids[i] = obs.getPeriodId(freq, i);
            if (ids[i] != ids[i - 1]) continue;
            return null;
        }
        int firstId = ids[0];
        int lastId = ids[n - 1];
        TsPeriod start = new TsPeriod(freq, firstId);
        int l = lastId - firstId + 1;
        if (l == n) {
            return new TsData(start, obs.getValues(), false);
        }
        return new TsData(start, TsDataCollector.expand(n, l, ids, obs::getValue), false);
    }

    private static double[] expand(int currentSize, int expectedSize, int[] ids, IntToDoubleFunction valueFunc) {
        double[] result = new double[expectedSize];
        Arrays.fill(result, Double.NaN);
        result[0] = valueFunc.applyAsDouble(0);
        for (int j = 1; j < currentSize; ++j) {
            result[ids[j] - ids[0]] = valueFunc.applyAsDouble(j);
        }
        return result;
    }
}

