/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.ComplexBuilder;

public final class ComplexMath {
    @Deprecated
    public static double abs(Complex c) {
        return ComplexMath.abs(c.getRe(), c.getIm());
    }

    static double abs(double re, double im) {
        return DataBlock.hypot(re, im);
    }

    static double absSquare(double x, double y) {
        return x * x + y * y;
    }

    public static Complex acos(Complex c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = 1.0 - (cr * cr - (ci = c.getIm()) * ci);
        double scale = ComplexMath.abs(tmpr, tmpi = -2.0 * cr * ci);
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        double re = cr - tmpi;
        double im = ci + tmpr;
        return Complex.cart(ComplexMath.arg(re, im), -Math.log(ComplexMath.abs(re, im)));
    }

    public static Complex acosec(Complex c) {
        ComplexBuilder tmp = new ComplexBuilder(c);
        tmp.inv();
        return ComplexMath.asin(tmp.build());
    }

    public static Complex acosh(Complex c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = cr * cr - (ci = c.getIm()) * ci - 1.0;
        double scale = ComplexMath.abs(tmpr, tmpi = 2.0 * cr * ci);
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        return ComplexMath.log(tmpr += cr, tmpi += ci);
    }

    public static Complex acot(Complex c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexBuilder tmp = new ComplexBuilder(-ci - 1.0, cr);
        tmp.div(1.0 - ci, cr);
        Complex ltmp = tmp.build();
        double re = ltmp.getRe();
        double im = ltmp.getIm();
        return Complex.cart(0.5 * ComplexMath.arg(re, im), -0.5 * Math.log(ComplexMath.abs(re, im)));
    }

    public static Complex acoth(Complex c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexBuilder tmp = new ComplexBuilder(cr + 1.0, ci);
        tmp.div(cr - 1.0, ci);
        double re = tmp.getRe();
        double im = tmp.getIm();
        return Complex.cart(0.5 * Math.log(ComplexMath.abs(re, im)), 0.5 * ComplexMath.arg(re, im));
    }

    static double arg(double re, double im) {
        return Math.atan2(im, re);
    }

    public static Complex asec(Complex c) {
        ComplexBuilder tmp = new ComplexBuilder(c);
        tmp.inv();
        return ComplexMath.acos(tmp.build());
    }

    public static Complex asin(Complex c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = 1.0 - (cr * cr - (ci = c.getIm()) * ci);
        double scale = ComplexMath.abs(tmpr, tmpi = -2.0 * cr * ci);
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        return Complex.cart(ComplexMath.arg(tmpr -= ci, tmpi += cr), -Math.log(ComplexMath.abs(tmpr, tmpi)));
    }

    public static Complex asinh(Complex c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = cr * cr - (ci = c.getIm()) * ci + 1.0;
        double scale = ComplexMath.abs(tmpr, tmpi = 2.0 * cr * ci);
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        return ComplexMath.log(tmpr += cr, tmpi += ci);
    }

    public static Complex atan(Complex c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexBuilder tmp = new ComplexBuilder(-cr, 1.0 - ci);
        tmp.div(cr, 1.0 + ci);
        Complex ltmp = tmp.build();
        double re = ltmp.getRe();
        double im = ltmp.getIm();
        return Complex.cart(0.5 * ComplexMath.arg(re, im), -0.5 * Math.log(ComplexMath.abs(re, im)));
    }

    public static Complex atanh(Complex c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexBuilder tmp = new ComplexBuilder(cr + 1.0, ci);
        tmp.div(1.0 - cr, -ci);
        double re = tmp.getRe();
        double im = tmp.getIm();
        return Complex.cart(0.5 * Math.log(ComplexMath.abs(re, im)), 0.5 * ComplexMath.arg(re, im));
    }

    public static Complex cos(Complex c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        return Complex.cart(0.5 * (re1 + re2), 0.5 * (im1 + im2));
    }

    public static Complex cosec(Complex c) {
        ComplexBuilder builder = new ComplexBuilder(ComplexMath.sin(c));
        builder.inv();
        return builder.build();
    }

    public static Complex cosh(Complex c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        return Complex.cart(0.5 * (re1 + re2), 0.5 * (im1 + im2));
    }

    public static Complex cot(Complex c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        ComplexBuilder result = new ComplexBuilder(0.5 * (re1 + re2), 0.5 * (im1 + im2));
        result.div(0.5 * (im1 - im2), -0.5 * (re1 - re2));
        return result.build();
    }

    public static Complex coth(Complex c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        ComplexBuilder result = new ComplexBuilder(re1 + re2, im1 + im2);
        result.div(re1 - re2, im1 - im2);
        return result.build();
    }

    public static Complex exp(Complex c) {
        return ComplexMath.exp(c.getRe(), c.getIm());
    }

    private static Complex exp(double a, double b) {
        double scalar = Math.exp(a);
        return Complex.cart(scalar * Math.cos(b), scalar * Math.sin(b));
    }

    public static Complex log(Complex c) {
        return Complex.cart(Math.log(c.abs()), c.arg());
    }

    static Complex log(double re, double im) {
        return Complex.cart(Math.log(ComplexMath.abs(re, im)), ComplexMath.arg(re, im));
    }

    public static Complex pow(Complex c, Complex exponent) {
        double re = Math.log(c.abs());
        double im = c.arg();
        double rtmp = re * exponent.getRe() - im * exponent.getIm();
        double itmp = re * exponent.getIm() + im * exponent.getRe();
        double scalar = Math.exp(rtmp);
        return Complex.cart(scalar * Math.cos(itmp), scalar * Math.sin(itmp));
    }

    public static Complex pow(Complex c, double exponent) {
        double re = exponent * Math.log(c.abs());
        double im = exponent * c.arg();
        double scalar = Math.exp(re);
        return Complex.cart(scalar * Math.cos(im), scalar * Math.sin(im));
    }

    public static Complex sec(Complex c) {
        ComplexBuilder builder = new ComplexBuilder(ComplexMath.cos(c));
        builder.inv();
        return builder.build();
    }

    public static Complex sin(Complex c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        return Complex.cart(0.5 * (im1 - im2), -0.5 * (re1 - re2));
    }

    public static Complex sinh(Complex c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        return Complex.cart(0.5 * (re1 - re2), 0.5 * (im1 - im2));
    }

    @Deprecated
    public static Complex sqrt(Complex c) {
        return ComplexMath.sqrt(c.getRe(), c.getIm());
    }

    static Complex sqrt(double re, double im) {
        double scale = ComplexMath.abs(re, im);
        if (scale > 0.0) {
            if (re > 0.0) {
                double tmp = Math.sqrt(0.5 * (scale + re));
                return Complex.cart(tmp, 0.5 * im / tmp);
            }
            double tmp = Math.sqrt(0.5 * (scale - re));
            if (im < 0.0) {
                tmp = -tmp;
            }
            return Complex.cart(0.5 * im / tmp, tmp);
        }
        return Complex.ZERO;
    }

    public static Complex tan(Complex c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        ComplexBuilder result = new ComplexBuilder(0.5 * (im1 - im2), -0.5 * (re1 - re2));
        result.div(0.5 * (re1 + re2), 0.5 * (im1 + im2));
        return result.build();
    }

    public static Complex tanh(Complex c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        ComplexBuilder result = new ComplexBuilder(re1 - re2, im1 - im2);
        result.div(re1 + re2, im1 + im2);
        return result.build();
    }

    private ComplexMath() {
    }
}

