/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ConcentratedLikelihoodEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;

public class ApproximateSingleOutlierDetector<T extends IArimaModel>
extends AbstractSingleOutlierDetector<T> {
    private double[] m_el;
    private SarimaModel m_stmodel;
    private BackFilter m_ur;

    public ApproximateSingleOutlierDetector() {
        this(IRobustStandardDeviationComputer.mad());
    }

    public ApproximateSingleOutlierDetector(IRobustStandardDeviationComputer computer) {
        super(computer);
    }

    @Override
    protected boolean calc() {
        if (!this.initmodel()) {
            return false;
        }
        for (int i = 0; i < this.getOutlierFactoriesCount(); ++i) {
            this.processOutlier(i);
        }
        return true;
    }

    @Override
    protected void clear(boolean all) {
        super.clear(all);
        this.m_el = null;
    }

    private boolean initmodel() {
        RegArimaModel model = this.getModel();
        this.m_stmodel = (SarimaModel)model.getArma();
        this.m_ur = this.getModel().getDifferencingFilter();
        ConcentratedLikelihoodEstimation estimation = new ConcentratedLikelihoodEstimation();
        if (!estimation.estimate(model)) {
            return false;
        }
        this.m_el = estimation.getResiduals();
        DataBlock EL = new DataBlock(this.m_el);
        this.getStandardDeviationComputer().compute(EL);
        return true;
    }

    private void processOutlier(int idx) {
        int nl = this.m_el.length;
        int d = this.m_ur.getDegree();
        int n = nl + d;
        IOutlierVariable outlier = this.getOutlierFactory(idx).create(this.getDomain().getStart().firstday());
        IOutlierVariable.FilterRepresentation representation = outlier.getFilterRepresentation(this.m_stmodel.getFrequency());
        if (representation == null) {
            return;
        }
        Object model = this.getModel().getArima();
        RationalBackFilter pi = model.getPiWeights();
        double[] o = pi.times(representation.filter).getWeights(n);
        double corr = 0.0;
        if (d == 0 && representation.correction != 0.0) {
            Polynomial ar = model.getAR().getPolynomial();
            Polynomial ma = model.getMA().getPolynomial();
            corr = representation.correction * ar.evaluateAt(1.0) / ma.evaluateAt(1.0);
            int i = 0;
            while (i < n) {
                int n2 = i++;
                o[n2] = o[n2] + corr;
            }
        }
        double sxx = 0.0;
        if (corr != 0.0) {
            sxx = corr * corr * (double)nl;
        }
        int lbound = this.getLBound();
        int ubound = this.getUBound();
        for (int ix = 0; ix < n; ++ix) {
            int pos;
            int kmax;
            double rmse = this.getStandardDeviationComputer().get(n - ix - 1 - d);
            sxx += o[ix] * o[ix];
            if (corr != 0.0) {
                sxx -= corr * corr;
            }
            if ((kmax = ix + 1) > nl) {
                kmax = nl;
                sxx -= o[ix - nl] * o[ix - nl];
                if (corr != 0.0) {
                    sxx += corr * corr;
                }
            }
            double sxy = 0.0;
            int k = 0;
            int ek = nl - 1;
            while (k < kmax) {
                sxy += this.m_el[ek] * o[ix - k];
                ++k;
                --ek;
            }
            if (corr != 0.0) {
                double cxy = 0.0;
                for (int k2 = 0; k2 < nl - kmax; ++k2) {
                    cxy += this.m_el[k2];
                }
                sxy += cxy * corr;
            }
            if ((pos = n - 1 - ix) < lbound || pos >= ubound) continue;
            double c = sxy / sxx;
            double val = c * Math.sqrt(sxx) / rmse;
            this.setCoefficient(pos, idx, c);
            this.setT(pos, idx, val);
        }
    }
}

