/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client;

import it.bankitalia.reri.sia.sdmx.api.DSDIdentifier;
import it.bankitalia.reri.sia.sdmx.api.DataFlowStructure;
import it.bankitalia.reri.sia.sdmx.api.Dimension;
import it.bankitalia.reri.sia.sdmx.api.GenericSDMXClient;
import it.bankitalia.reri.sia.sdmx.api.PortableTimeSeries;
import it.bankitalia.reri.sia.sdmx.client.Provider;
import it.bankitalia.reri.sia.sdmx.client.SDMXClientFactory;
import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.LoginDialog;
import it.bankitalia.reri.sia.util.SdmxException;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class SdmxClientHandler {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String sourceClass = SdmxClientHandler.class.getSimpleName();
    private static final String VERSION = "latest";
    private static Map<String, GenericSDMXClient> clients = new Hashtable<String, GenericSDMXClient>();

    public static boolean needsCredentials(String string) throws SdmxException {
        return SdmxClientHandler.getClient(string).needsCredentials();
    }

    public static void setCredentials(String string, String string2, String string3) throws SdmxException {
        SdmxClientHandler.getClient(string, string2, string3);
    }

    public static void addProvider(String string, String string2, String string3, boolean bl) {
        try {
            URL uRL = new URL(string3);
            SDMXClientFactory.addProvider(string, string2, uRL, bl);
        }
        catch (MalformedURLException malformedURLException) {
            logger.severe("Exception. Class: " + malformedURLException.getClass().getName() + " .Message: " + malformedURLException.getMessage());
            logger.log(Level.FINER, "", malformedURLException);
        }
    }

    public static List<String> getProviders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = SDMXClientFactory.getProviders().keySet();
        if (set != null) {
            arrayList = new ArrayList<String>(set);
        }
        return arrayList;
    }

    public static DataFlowStructure getDataFlowStructure(String string, String string2) throws SdmxException {
        DataFlowStructure dataFlowStructure = null;
        DSDIdentifier dSDIdentifier = SdmxClientHandler.getDSDIdentifier(string, string2);
        if (dSDIdentifier != null) {
            String string3 = dSDIdentifier.getFullName();
            Provider provider = SdmxClientHandler.getProvider(string);
            dataFlowStructure = provider.getDSD(string3);
            if (dataFlowStructure == null) {
                logger.info("DSD for " + dSDIdentifier.getFullName() + " not cached. Call Provider.");
                try {
                    dataFlowStructure = SdmxClientHandler.getClient(string).getDataFlowStructure(dSDIdentifier);
                    provider.setDSD(string3, dataFlowStructure);
                    SdmxClientHandler.delay();
                }
                catch (SdmxException sdmxException) {
                    logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                    logger.log(Level.FINER, "", sdmxException);
                }
            }
        } else {
            throw new SdmxException("The dataflow: '" + string2 + "' does not exist in provider: '" + string + "'");
        }
        return dataFlowStructure;
    }

    public static DSDIdentifier getDSDIdentifier(String string, String string2) throws SdmxException {
        String string3 = SdmxClientHandler.getClient(string).getAgency() + "/" + string2 + "/" + VERSION;
        Provider provider = SdmxClientHandler.getProvider(string);
        DSDIdentifier dSDIdentifier = null;
        dSDIdentifier = provider.getDSDIdentifier(string3);
        if (dSDIdentifier == null) {
            logger.info("DSD identifier for dataflow " + string3 + " not cached. Call Provider.");
            try {
                dSDIdentifier = SdmxClientHandler.getClient(string).getDSDIdentifier(string2, VERSION);
                provider.setDSDIdentifier(string3, dSDIdentifier);
                SdmxClientHandler.delay();
            }
            catch (SdmxException sdmxException) {
                logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                logger.log(Level.FINER, "", sdmxException);
            }
        }
        return dSDIdentifier;
    }

    public static List<Dimension> getDimensions(String string, String string2) throws SdmxException {
        List<Dimension> list = null;
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        if (dataFlowStructure == null) {
            throw new SdmxException("The dataflow: '" + string2 + "' does not exist in provider: '" + string + "'");
        }
        list = dataFlowStructure.getDimensions();
        return list;
    }

    public static Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        Map<String, String> map = null;
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        Dimension dimension = dataFlowStructure.getDimension(string3);
        if (dimension != null) {
            map = dimension.getCodes();
            if (map == null) {
                try {
                    logger.info("Codelist for " + string + ", " + string2 + ", " + string3 + " not cached.");
                    String string4 = dataFlowStructure.getDimension(string3).getCodeList();
                    map = SdmxClientHandler.getClient(string).getCodes(string, string4);
                    dataFlowStructure.setCodes(string3, map);
                }
                catch (SdmxException sdmxException) {
                    logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                    logger.log(Level.FINER, "", sdmxException);
                }
            }
        } else {
            throw new SdmxException("The dimension: '" + string3 + "' does not exist in dataflow: '" + string2 + "'");
        }
        return map;
    }

    public static Map<String, String> getFlows(String string, String string2) throws SdmxException {
        Map<String, String> map = null;
        Provider provider = SdmxClientHandler.getProvider(string);
        map = provider.getFlows();
        if (map == null || map.size() == 0) {
            logger.info("Flows for " + string + " not cached. Call Provider.");
            try {
                map = SdmxClientHandler.getClient(string).getDataflows();
                provider.setFlows(map);
            }
            catch (SdmxException sdmxException) {
                logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                logger.log(Level.FINER, "", sdmxException);
            }
        }
        return SdmxClientHandler.filterFlows(map, string2);
    }

    public static List<PortableTimeSeries> getTimeSeries(String string, String string2, String string3, String string4) throws SdmxException {
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        String[] stringArray = string2.split("\\s*,\\s*");
        for (int i = 0; i < stringArray.length; ++i) {
            List<PortableTimeSeries> list = SdmxClientHandler.getSingleTimeSeries(string, stringArray[i], string3, string4);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<PortableTimeSeries> getSingleTimeSeries(String string, String string2, String string3, String string4) throws SdmxException {
        List<PortableTimeSeries> list = null;
        String string5 = null;
        String string6 = null;
        String string7 = "[ /]";
        String[] stringArray = string2.split(string7, 2);
        if (stringArray.length == 2) {
            string5 = stringArray[0];
            string6 = stringArray[1];
        } else {
            stringArray = SdmxClientHandler.translateLegacyTSQuery(string2);
            string5 = stringArray[0];
            string6 = stringArray[1];
        }
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string5);
        try {
            list = SdmxClientHandler.getClient(string).getTimeSeries(string5, dataFlowStructure, string6, string3, string4);
        }
        catch (SdmxException sdmxException) {
            logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
            logger.log(Level.FINER, "", sdmxException);
        }
        return list;
    }

    public static String dumpTimeSeries(String string, String string2, String string3, String string4) throws SdmxException {
        StringBuffer stringBuffer = new StringBuffer("");
        List<PortableTimeSeries> list = SdmxClientHandler.getTimeSeries(string, string2, string3, string4);
        int n = 0;
        Iterator<PortableTimeSeries> iterator = list.iterator();
        while (iterator.hasNext()) {
            PortableTimeSeries portableTimeSeries = iterator.next();
            stringBuffer.append(",").append(portableTimeSeries.getName());
            int n2 = portableTimeSeries.getObservations().size();
            if (n2 > n) {
                n = n2;
            }
            if (iterator.hasNext()) {
                stringBuffer.append(",");
            }
            if (!Configuration.isReverse()) continue;
            portableTimeSeries.reverse();
        }
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (i < list.get(j).getObservations().size()) {
                    stringBuffer.append(list.get(j).getTimeSlots().get(i)).append(",");
                    stringBuffer.append(list.get(j).getObservations().get(i));
                } else {
                    stringBuffer.append(",");
                }
                if (j + 1 >= list.size()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static Provider getProvider(String string) throws SdmxException {
        Provider provider = SDMXClientFactory.getProviders().get(string);
        if (provider == null) {
            throw new SdmxException("The provider " + string + " does not exist.");
        }
        return provider;
    }

    private static GenericSDMXClient getClient(String string, String string2, String string3) throws SdmxException {
        logger.entering(sourceClass, "getClient");
        GenericSDMXClient genericSDMXClient = clients.get(string);
        if (genericSDMXClient == null) {
            logger.info("Client for " + string + " does not exist. Create it.");
            genericSDMXClient = SDMXClientFactory.createClient(string);
            if (genericSDMXClient.needsCredentials()) {
                SdmxClientHandler.handlePassword(genericSDMXClient, string2, string3);
            }
            clients.put(string, genericSDMXClient);
        }
        logger.exiting(sourceClass, "getClient");
        return genericSDMXClient;
    }

    private static GenericSDMXClient getClient(String string) throws SdmxException {
        return SdmxClientHandler.getClient(string, null, null);
    }

    private static void handlePassword(GenericSDMXClient genericSDMXClient, String string, String string2) {
        if (genericSDMXClient.needsCredentials()) {
            if (string == null || string2 == null) {
                JFrame jFrame = new JFrame(genericSDMXClient.getAgency() + " Authentication");
                jFrame.setDefaultCloseOperation(2);
                LoginDialog loginDialog = new LoginDialog((Frame)jFrame, genericSDMXClient.getAgency() + " Authentication");
                loginDialog.setVisible(true);
                genericSDMXClient.setCredentials(loginDialog.getUsername(), loginDialog.getPassword());
                jFrame.dispose();
            } else {
                genericSDMXClient.setCredentials(string, string2);
            }
        }
    }

    private static Map<String, String> filterFlows(Map<String, String> map, String string) {
        logger.entering(sourceClass, "filterFlows");
        Map<String, String> map2 = map;
        if (string != null && !string.trim().isEmpty()) {
            map2 = new Hashtable<String, String>();
            string = string.replaceAll("\\*", ".*").replaceAll("\\?", ".");
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (!string2.matches(string) && !string3.matches(string)) continue;
                map2.put(string2, string3);
            }
        }
        logger.exiting(sourceClass, "filterFlows");
        return map2;
    }

    private static String[] translateLegacyTSQuery(String string) {
        String[] stringArray = new String[2];
        String string2 = "[.]";
        String[] stringArray2 = string.split(string2, 2);
        if (stringArray2.length == 2) {
            stringArray[0] = stringArray2[0];
            String string3 = stringArray2[1];
            string3 = string3.replace("*", "");
            stringArray[1] = string3 = string3.replace('|', '+');
        } else {
            logger.severe("Error in query string format: '" + string + "'. Could not get dataflow id.");
        }
        return stringArray;
    }

    private static void delay() {
        long l = Configuration.getDelay();
        if (l > 0L) {
            try {
                Thread.sleep(Configuration.getDelay());
            }
            catch (InterruptedException interruptedException) {
                logger.warning("Error with delay");
            }
        }
    }
}

