/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.parser.v20;

import it.bankitalia.reri.sia.sdmx.api.PortableTimeSeries;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class GenericDataParser {
    private static final String SERIES = "Series";
    private static final String SERIES_KEY = "SeriesKey";
    private static final String VALUE = "value";
    private static final String CONCEPT = "concept";
    private static final String OBS = "Obs";
    private static final String OBS_TIME = "Time";
    private static final String OBS_VALUE = "ObsValue";
    private static final String ATTRIBUTES = "Attributes";

    public static List<PortableTimeSeries> parse(String string, String string2) throws XMLStreamException, UnsupportedEncodingException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(byteArrayInputStream);
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        PortableTimeSeries portableTimeSeries = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    portableTimeSeries = new PortableTimeSeries();
                    portableTimeSeries.setDataflow(string2);
                }
                if (xMLEvent.getName().getLocalPart() == SERIES_KEY) {
                    GenericDataParser.setSeriesKey(portableTimeSeries, xMLEventReader);
                }
                if (xMLEvent.getName().getLocalPart() == ATTRIBUTES) {
                    GenericDataParser.setSeriesAttributes(portableTimeSeries, xMLEventReader);
                }
                if (xMLEvent.getName().getLocalPart() == OBS) {
                    GenericDataParser.setSeriesSingleObs(portableTimeSeries, xMLEventReader);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES) continue;
            arrayList.add(portableTimeSeries);
        }
        return arrayList;
    }

    private static void setSeriesKey(PortableTimeSeries portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement() && (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                Iterator<Attribute> iterator = xMLEvent.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equalsIgnoreCase(CONCEPT)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    string2 = attribute.getValue();
                }
            }
            if (xMLEvent2.isEndElement() && (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                portableTimeSeries.addDimension(string + '=' + string2);
                if (string.equalsIgnoreCase("FREQ") || string.equalsIgnoreCase("FREQUENCY")) {
                    portableTimeSeries.setFrequency(string2);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES_KEY) continue;
            break;
        }
    }

    private static void setSeriesAttributes(PortableTimeSeries portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement() && (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                Iterator<Attribute> iterator = xMLEvent.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equalsIgnoreCase(CONCEPT)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    string2 = attribute.getValue();
                }
            }
            if (xMLEvent2.isEndElement() && (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                portableTimeSeries.addAttribute(string + '=' + string2);
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != ATTRIBUTES) continue;
            break;
        }
    }

    private static void setSeriesSingleObs(PortableTimeSeries portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == OBS_TIME) {
                    string = xMLEventReader.getElementText();
                }
                if (xMLEvent.getName().getLocalPart() == OBS_VALUE) {
                    string2 = xMLEvent.getAttributeByName(new QName(VALUE)).getValue();
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != OBS) continue;
            portableTimeSeries.addObservation(new Double(string2), string, "");
            break;
        }
    }
}

