/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.SDMXClientFactory;
import it.bancaditalia.oss.sdmx.helper.AboutActionListener;
import it.bancaditalia.oss.sdmx.helper.BuildCommandActionListener;
import it.bancaditalia.oss.sdmx.helper.HelperHandler;
import it.bancaditalia.oss.sdmx.helper.ProviderActionListener;
import it.bancaditalia.oss.sdmx.helper.ProviderComparator;
import it.bancaditalia.oss.sdmx.helper.QueryPanel;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;

public class SDMXHelper
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Configuration.getSdmxLogger();
    private boolean exitOnClose = true;
    static QueryPanel query = new QueryPanel();
    private JTextArea sdmxMessages;
    private HelperHandler textAreaHandler = null;

    public SDMXHelper() {
        super("SDMX Helper Tool");
    }

    public SDMXHelper(boolean bl) {
        super("SDMX Helper Tool");
        this.exitOnClose = bl;
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
        }
        this.setSize(800, 600);
        this.setJMenuBar(this.createMenus());
        this.sdmxMessages = new JTextArea();
        this.sdmxMessages.setEditable(false);
        this.sdmxMessages.setBackground(Color.LIGHT_GRAY);
        this.textAreaHandler = new HelperHandler(this.sdmxMessages);
        logger.addHandler(this.textAreaHandler);
        JScrollPane jScrollPane = new JScrollPane(this.sdmxMessages);
        jScrollPane.setAutoscrolls(true);
        JSplitPane jSplitPane = new JSplitPane(0, query, jScrollPane);
        jSplitPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)jSplitPane, "Center");
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                if (SDMXHelper.this.exitOnClose) {
                    jFrame.setDefaultCloseOperation(3);
                } else {
                    jFrame.setDefaultCloseOperation(1);
                }
                logger.removeHandler(SDMXHelper.this.textAreaHandler);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setVisible(true);
    }

    private JMenuBar createMenus() {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Providers");
        jMenuBar.add(jMenu);
        ArrayList<Provider> arrayList = new ArrayList<Provider>(SDMXClientFactory.getProviders().values());
        Collections.sort(arrayList, new ProviderComparator());
        for (Provider provider : arrayList) {
            String string = provider.getName() + ": " + provider.getDescription();
            jMenuItem = new JMenuItem(string);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ProviderActionListener(this));
        }
        jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText("Copy Selection");
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Build commands");
        jMenuItem.addActionListener(new BuildCommandActionListener(this));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("About SDMX Connectors...");
        jMenuItem.addActionListener(new AboutActionListener(this));
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    public static void start() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SDMXHelper sDMXHelper = new SDMXHelper(false);
                sDMXHelper.init();
            }
        });
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SDMXHelper sDMXHelper = new SDMXHelper(true);
                sDMXHelper.init();
            }
        });
    }
}

