/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v20;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.parser.v20.CodelistParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataStructureParser {
    private static final String sourceClass = DataStructureParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String DATASTRUCTURE = "KeyFamily";
    static final String CODELISTS = "CodeLists";
    static final String CODELIST = "CodeList";
    static final String CODELIST2 = "codelist";
    static final String CONCEPTS = "Concepts";
    static final String CONCEPT = "Concept";
    static final String COMPONENTS = "Components";
    static final String NAME = "Name";
    static final String DIMENSION = "Dimension";
    static final String ATTRIBUTE = "Attribute";
    static final String TIMEDIMENSION = "TimeDimension";
    static final String CONCEPT_REF = "conceptRef";
    static final String ID = "id";
    static final String AGENCYID = "agencyID";
    static final String LOCAL_REPRESENTATION = "LocalRepresentation";
    static final String REF = "Ref";

    public static List<DataFlowStructure> parse(InputStreamReader inputStreamReader) throws XMLStreamException, SdmxException, UnsupportedEncodingException {
        logger.entering(sourceClass, "parse");
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(inputStreamReader);
        ArrayList<DataFlowStructure> arrayList = new ArrayList<DataFlowStructure>();
        Map<String, Map<String, String>> map = null;
        Map<String, String> map2 = null;
        DataFlowStructure dataFlowStructure = null;
        LocalizedText localizedText = new LocalizedText(Configuration.getLang());
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == CODELISTS) {
                    map = DataStructureParser.getCodelists(xMLEventReader);
                } else if (startElement.getName().getLocalPart() == CONCEPTS) {
                    map2 = DataStructureParser.getConcepts(xMLEventReader);
                } else if (startElement.getName().getLocalPart() == DATASTRUCTURE) {
                    dataFlowStructure = new DataFlowStructure();
                    localizedText.clear();
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        String string = null;
                        String string2 = null;
                        if (attribute.getName().toString().equals(ID)) {
                            string = attribute.getValue();
                            dataFlowStructure.setId(string);
                            continue;
                        }
                        if (!attribute.getName().toString().equals(AGENCYID)) continue;
                        string2 = attribute.getValue();
                        dataFlowStructure.setAgency(string2);
                    }
                } else if (startElement.getName().getLocalPart().equals(NAME)) {
                    if (dataFlowStructure != null) {
                        localizedText.setText(startElement, xMLEventReader);
                    }
                } else if (startElement.getName().getLocalPart().equals(COMPONENTS)) {
                    if (dataFlowStructure != null) {
                        DataStructureParser.setStructureDimensionsAndAttributes(dataFlowStructure, xMLEventReader, map, map2);
                    } else {
                        throw new RuntimeException("Error during Structure Parsing. Null current structure.");
                    }
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(DATASTRUCTURE)) continue;
            logger.finer("Adding data structure. " + dataFlowStructure);
            dataFlowStructure.setName(localizedText.getText());
            arrayList.add(dataFlowStructure);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setStructureDimensionsAndAttributes(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader, Map<String, Map<String, String>> map, Map<String, String> map2) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureDimensions");
        String string = dataFlowStructure.getAgency();
        Dimension dimension = null;
        int n = 0;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                String string2;
                Iterator<Attribute> iterator;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals(DIMENSION)) {
                    Object object2;
                    logger.finer("Got dimension");
                    iterator = startElement.getAttributes();
                    string2 = null;
                    object = null;
                    dimension = new Dimension();
                    dimension.setPosition(++n);
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        if (object2.getName().toString().equals(CONCEPT_REF)) {
                            string2 = object2.getValue();
                            continue;
                        }
                        if (!object2.getName().toString().equals(CODELIST2)) continue;
                        object = object2.getValue();
                    }
                    if (string2 == null || string2.isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid id: " + string2);
                    dimension.setId(string2);
                    if (map2 != null) {
                        dimension.setName(map2.get(string + "/" + string2));
                    }
                    if (object == null || ((String)object).isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid CODELIST: " + (String)object);
                    object2 = new Codelist((String)object, string, null);
                    if (map != null) {
                        Map<String, String> map3 = map.get(((Codelist)object2).getFullIdentifier());
                        ((Codelist)object2).setCodes(map3);
                    }
                    dimension.setCodeList((Codelist)object2);
                } else if (startElement.getName().getLocalPart().equals(TIMEDIMENSION)) {
                    logger.finer("Got time dimension");
                    iterator = startElement.getAttributes();
                    string2 = null;
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!object.getName().toString().equals(CONCEPT_REF)) continue;
                        string2 = object.getValue();
                    }
                    if (string2 == null || string2.isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + string2);
                    if (dataFlowStructure == null) throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                    logger.finer("Adding time dimension: " + string2);
                    dataFlowStructure.setTimeDimension(string2);
                    continue;
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            if (xMLEvent.asEndElement().getName().getLocalPart().equals(DIMENSION)) {
                if (dataFlowStructure == null || dimension == null) throw new RuntimeException("Error during Structure Parsing. Null current structure or dimension.");
                logger.finer("Adding dimension: " + dimension);
                dataFlowStructure.setDimension(dimension);
                continue;
            }
            if (!xMLEvent.asEndElement().getName().getLocalPart().equals(COMPONENTS)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureDimensions");
    }

    private static Map<String, Map<String, String>> getCodelists(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        Hashtable<String, Map<String, String>> hashtable = new Hashtable<String, Map<String, String>>();
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (startElement = xMLEvent.asStartElement()).getName().getLocalPart().equals(CODELIST)) {
                Object object;
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = null;
                String string3 = "";
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object.getName().toString().equals(ID)) {
                        string = object.getValue();
                        continue;
                    }
                    if (!object.getName().toString().equals(AGENCYID)) continue;
                    string2 = object.getValue();
                }
                string3 = string2 + "/" + string;
                logger.finer("Got codelist: " + string3);
                object = CodelistParser.getCodes(xMLEventReader);
                hashtable.put(string3, (Map<String, String>)object);
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CODELISTS)) continue;
            break;
        }
        return hashtable;
    }

    private static Map<String, String> getConcepts(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (startElement = xMLEvent.asStartElement()).getName().getLocalPart().equals(CONCEPT)) {
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = null;
                String string3 = "";
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals(AGENCYID)) continue;
                    string2 = attribute.getValue();
                }
                string3 = string2 + "/" + string;
                logger.finer("Got concept: " + string3);
                hashtable.put(string3, DataStructureParser.getConceptName(xMLEventReader));
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CONCEPTS)) continue;
            break;
        }
        return hashtable;
    }

    private static String getConceptName(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        LocalizedText localizedText = new LocalizedText(Configuration.getLang());
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (object = xMLEvent.asStartElement()).getName().getLocalPart() == NAME) {
                localizedText.setText((StartElement)object, xMLEventReader);
            }
            if (!xMLEvent.isEndElement() || !((String)(object = xMLEvent.asEndElement().getName().getLocalPart())).equals(CONCEPT)) continue;
            break;
        }
        return localizedText.getText();
    }
}

