% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset11}
\alias{dataset11}
\title{Dobbins 1 FROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:4, 1:5, 1:158, 1:4], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:4, 1:5, 1:115, 1:20], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:115], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:115, 1:20], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:115, 1:20], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset11", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "FROC", the data type}
\item{\code{descriptions$name}}{, chr "DOBBINS-1", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:4, 1:5, 1:158, 1:21], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:4] "1" "2" "3" "4", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:5] "1" "2" "3" "4" ..., reader labels}
}
}
\usage{
dataset11
}
\description{
This is referred to in the book as the "DOB1" dataset. Dobbins et al conducted a 
multi-institutional, MRMC study to compare the performance of digital tomosynthesis 
(GE's VolumeRad device), dual-energy (DE) imaging, and conventional chest 
radiography for pulmonary nodule detection and management. 
All study images were obtained with a flat-panel detector developed by GE. 
The case set consisted of 158 subjects, of which 43 were non-diseased and 
the rest had 1 - 20 pulmonary nodules independently verified, using with CT 
images, by 3 experts who did not participate in the observer study. The 
study used FROC paradigm data collection. There are 
4 treatments labeled 1 - 4 (conventional chest x-ray, CXR, CXR augmented
with dual-energy (CXR+DE), VolumeRad digital tomosynthesis images and 
VolumeRad augmented with DE (VolumeRad+DE).
}
\examples{
str(dataset11)


}
\references{
Dobbins III JT et al. Multi-Institutional Evaluation of Digital 
Tomosynthesis, Dual-Energy Radiography, and Conventional Chest Radiography 
for the Detection and Management of Pulmonary Nodules. Radiology. 2016;282(1):236-250.
}
\keyword{datasets}
