% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{ggplotly}
\alias{ggplotly}
\title{Experimental: Convert ggplot2 to plotly with hyperlinks to KorAP queries}
\usage{
ggplotly(p = ggplot2::last_plot(), tooltip = c("x", "y", "colour", "url"), ...)
}
\arguments{
\item{p}{a ggplot object.}

\item{tooltip}{a character vector specifying which aesthetic mappings to show
in the tooltip. If you want hyperlinks to KorAP queries you need to include
\code{"url"} here.}

\item{...}{Other arguments passed to \code{plotly::ggplotly}}
}
\description{
\code{RKorAPClient::ggplotly} converts a \code{ggplot2::ggplot()} object to a plotly
object with hyperlinks from data points to corresponding KorAP queries.
\bold{Warning:} This function may be moved to a new package.
}
\examples{
library(ggplot2)
kco <- new("KorAPConnection", verbose=TRUE)
\donttest{year <- (2003:2011)}\dontshow{year <- c(2005)}
\donttest{condition <- c("textDomain = /Wirtschaft.*/", "textDomain != /Wirtschaft.*/")}\dontshow{condition <- c("textDomain = /Wirtschaft.*/")}
g <- expand_grid(condition, year) \%>\%
  cbind(frequencyQuery(kco, "[tt/l=Heuschrecke]",
                       paste0(.$condition," & pubDate in ", .$year)))  \%>\%
  ipm() \%>\%
  ggplot(aes(year, ipm, fill = condition, color = condition)) +
  ##  theme_light(base_size = 20) +
  geom_freq_by_year_ci()
p <- ggplotly(g)
print(p)
## saveWidget(p, paste0(tmpdir(), "heuschrecke.html")


}
