% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_MC_CW_IRSL_LOC.R
\encoding{UTF-8}
\name{run_MC_CW_IRSL_LOC}
\alias{run_MC_CW_IRSL_LOC}
\title{Monte-Carlo Simulation for CW-IRSL (localized transitions)}
\usage{
run_MC_CW_IRSL_LOC(
  A,
  times,
  clusters = 10,
  n_filled = 100,
  r,
  method = "par",
  output = "signal",
  ...
)
}
\arguments{
\item{A}{\link{numeric} (\strong{required}): The optical excitation rate from the ground state of the trap to the excited state (\code{s^-1})}

\item{times}{\link{numeric} (\strong{required}): The sequence of time steps within the simulation (s)}

\item{clusters}{\link{numeric} (\emph{with default}): The number of created clusters for the MC runs. The input can be the output of \link{create_ClusterSystem}. In that case \code{n_filled} indicate absolute numbers of a system.}

\item{n_filled}{\link{integer} (\emph{with default}): The number of filled electron traps at the beginning
of the simulation (dimensionless). Can be a vector of \code{length(clusters)}, shorter values are recycled.}

\item{r}{\link{numeric} (\strong{required}): The retrapping ratio for localized transitions}

\item{method}{\link{character} (\emph{with default}): Sequential \code{'seq'} or parallel \code{'par'}processing. In
the parallel mode the function tries to run the simulation on multiple CPU cores (if available) with
a positive effect on the computation time.}

\item{output}{\link{character} (\emph{with default}): output is either the \code{'signal'} (the default) or
\code{'remaining_e'} (the remaining charges/electrons in the trap)}

\item{\dots}{further arguments, such as \code{cores} to control the number of used CPU cores or \code{verbose} to silence the terminal}
}
\value{
This function returns an object of class \code{RLumCarlo_Model_Output} which
is a \link{list} consisting of an \link{array} with dimension \code{length(times)} x clusters
and a \link{numeric} time vector.
}
\description{
Runs a Monte-Carlo (MC) simulation of continuous wave infrared stimulated luminescence
(CW-IRSL) using the generalized one trap (GOT) model. Localized transitions refer to transitions
which do not involve the conduction or valence band. These transitions take place between the
ground state and an excited state of the trapped charge, and also involve an energy state of the
recombination centre.
}
\details{
\strong{The model}
\deqn{
I_{LOC}(t) = -dn/dt = A * (n^2 / (r + n))
}

where in the function: \cr
A := optical excitation rate from the ground state into the excited state of the trap (s^-1) \cr
r := retrapping ratio for localized transitions \cr
t := time (s)\cr
n := number of filled electron traps
}
\section{Function version}{
 0.1.0
}

\examples{
run_MC_CW_IRSL_LOC(
 A = 0.12,
 times = 0:100,
 clusters = 50,
 n_filled = 100,
 r = 1e-7,
 method = "seq",
 output = "signal"
) \%>\%
plot_RLumCarlo(legend = TRUE)

} 

\section{How to cite}{
Kreutzer, S., 2022. run_MC_CW_IRSL_LOC(): Monte-Carlo Simulation for CW-IRSL (localized transitions). Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Pagonis, V., Schmidt, C., 2022. RLumCarlo: Monte-Carlo Methods for Simulating Luminescence Phenomena. R package version 0.1.8. https://CRAN.R-project.org/package=RLumCarlo
}

\references{
Pagonis, V., Friedrich, J., Discher, M., Müller-Kirschbaum, A., Schlosser, V., Kreutzer, S.,
Chen, R. and Schmidt, C., 2019. Excited state luminescence signals from a
random distribution of defects: A new Monte Carlo simulation approach for feldspar.
Journal of Luminescence 207, 266–272. \doi{10.1016/j.jlumin.2018.11.024}

\strong{Further reading}

Chen, R., McKeever, S.W.S., 1997. Theory of Thermoluminescence and Related Phenomena.
WORLD SCIENTIFIC. \doi{10.1142/2781}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
}
\keyword{data}
\keyword{models}
