% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_index_lapply}
\alias{mvl_index_lapply}
\title{Apply function to indices of nearby rows}
\usage{
mvl_index_lapply(index, data_list, fn)
}
\arguments{
\item{index}{MVL_OBJECT computed by \code{mvl_write_spatial_index1} or \code{mvl_write_extent_index}}

\item{data_list}{a list of vectors of equal length. They can be MVL_OBJECTs or R vectors, or a data.fame.}

\item{fn}{a function of two arguments - and index into \code{data_list} and a corresponding list of indices}
}
\value{
a list of results of function \code{fn}
}
\description{
This function is passed the index computed by \code{mvl_write_spatial_index1} or \code{mvl_write_extent_index} and a list of vectors, which are interpreted in a data frame fashion, or an R data.frame.
For each row we retrieve that set of indices that matches it and call function fn(i, idx) with index i of row being processed and vector idx listing matched indices.
}
\details{
The notion of "matched indices" is specific to the type of index being used.

For an index created with \code{mvl_write_spatial_index1} we return the indices of nearby rows. The user should apply an additional cut to narrow down to actual indices needed.

For an index created with \code{mvl_write_extent_index} we return the indices of rows with identical hashes. Even though 64-bit hashes produce very few collisions, it is recommended to apply additional cut to ensure that only the exactly matching rows are returned.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, data.frame(x=runif(100), y=1:100), "df1")
Mtmp<-mvl_remap(Mtmp)
mvl_write_spatial_index1(Mtmp, list(Mtmp$df1[,"x",ref=TRUE], Mtmp$df1[,"y", ref=TRUE]),
                                                               c(2, 3), "df1_sp_groups")
Mtmp<-mvl_remap(Mtmp)
mvl_index_lapply(Mtmp["df1_sp_groups", ref=TRUE], list(c(0.5, 0.6), c(2, 3)),
                                           function(i, idx) { return(list(i, idx))})
}
}
\seealso{
\code{\link{mvl_group}}
}
