% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MariaDBConnection.R,
%   R/dbDisconnect_MariaDBConnection.R, R/dbGetInfo_MariaDBConnection.R,
%   R/dbIsValid_MariaDBConnection.R, R/show_MariaDBConnection.R
\docType{class}
\name{MariaDBConnection-class}
\alias{MariaDBConnection-class}
\alias{MariaDBConnection}
\alias{MySQLConnection}
\alias{MySQLConnection-class}
\alias{format.MariaDBConnection}
\alias{dbDisconnect_MariaDBConnection}
\alias{dbDisconnect,MariaDBConnection-method}
\alias{dbGetInfo_MariaDBConnection}
\alias{dbGetInfo,MariaDBConnection-method}
\alias{dbIsValid_MariaDBConnection}
\alias{dbIsValid,MariaDBConnection-method}
\alias{show_MariaDBConnection}
\alias{show,MariaDBConnection-method}
\title{Class MariaDBConnection.}
\usage{
\method{format}{MariaDBConnection}(x, ...)

\S4method{dbDisconnect}{MariaDBConnection}(conn, ...)

\S4method{dbGetInfo}{MariaDBConnection}(dbObj, what = "", ...)

\S4method{dbIsValid}{MariaDBConnection}(dbObj, ...)

\S4method{show}{MariaDBConnection}(object)
}
\description{
\code{"MariaDBConnection"} objects are usually created by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.
They represent a connection to a MariaDB or MySQL database.
}
\details{
The \code{"MySQLConnection"} class is a subclass of \code{"MariaDBConnection"}.
Objects of that class are created by \code{dbConnect(MariaDB(), ..., mysql = TRUE)}
to indicate that the server is a MySQL server.
The \pkg{RMariaDB} package supports both MariaDB and MySQL servers, but the SQL dialect
and other details vary.
The default is to detect the server type based on the version number.

The older \pkg{RMySQL} package also implements the \code{"MySQLConnection"} class.
The S4 system is able to distinguish between \pkg{RMariaDB} and \pkg{RMySQL} objects
even if both packages are loaded.
}
\keyword{internal}
