% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PIMS}
\alias{PIMS}
\title{Display PIM for a parameter}
\usage{
PIMS(model, parameter, simplified = TRUE, use.labels = TRUE)
}
\arguments{
\item{model}{mark model object}

\item{parameter}{character string of a particular type of parameter in the
model (eg "p","Phi","pent","S")}

\item{simplified}{if TRUE show simplified PIM structure; otherwise show full
structure}

\item{use.labels}{if TRUE, uses time and cohort labels for columns and rows
respectively}
}
\value{
None
}
\description{
Extract PIMS for a particular parameter and display either the full PIM
structure or the simplified PIM structure.
}
\examples{
\donttest{
data(dipper)
results=mark(dipper)
PIMS(results,"Phi")
PIMS(results,"Phi",simplified=FALSE)
}
}
\author{
Jeff Laake
}
\seealso{
\code{\link{make.design.data}}
}
\keyword{utility}

