/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dataretrieval;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.dataretrieval.ServiceData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseAxisDataLocator {
    private static final Log log = LogFactory.getLog(BaseAxisDataLocator.class);
    protected ServiceData[] dataList = null;
    private OutputForm outputform = OutputForm.INLINE_FORM;

    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws DataRetrievalException {
        log.trace((Object)"Default Base DataLocator getData starts");
        OutputForm outputform = request.getOutputForm();
        if (outputform == null) {
            outputform = OutputForm.INLINE_FORM;
        }
        Data[] output = null;
        String outputFormString = outputform.getType();
        output = outputform == OutputForm.INLINE_FORM ? this.outputInlineForm(msgContext, this.dataList) : (outputform == OutputForm.LOCATION_FORM ? this.outputLocationForm(this.dataList) : (outputform == OutputForm.REFERENCE_FORM ? this.outputReferenceForm(msgContext, this.dataList) : this.outputInlineForm(msgContext, this.dataList)));
        if (output == null) {
            log.info((Object)("Null data return! Data Locator does not know how to handle request for dialect= " + request.getDialect() + " in the form of " + outputFormString));
        }
        log.trace((Object)"Default Base DataLocator getData ends");
        return output;
    }

    protected Data[] outputInlineForm(MessageContext msgContext, ServiceData[] serviceData) throws DataRetrievalException {
        OMElement metaElement = null;
        ArrayList<Data> result = new ArrayList<Data>();
        if (serviceData != null) {
            int size = serviceData.length;
            for (int i = 0; i < size; ++i) {
                metaElement = serviceData[i].getFileContent(msgContext.getAxisService().getClassLoader());
                if (metaElement == null) continue;
                result.add(new Data(metaElement, serviceData[i].getIdentifier()));
            }
        }
        return result.toArray(new Data[0]);
    }

    protected Data[] outputLocationForm(ServiceData[] serviceData) throws DataRetrievalException {
        ArrayList<Data> result = new ArrayList<Data>();
        if (serviceData != null) {
            for (int i = 0; i < serviceData.length; ++i) {
                String urlValue = serviceData[i].getURL();
                if (urlValue == null) continue;
                result.add(new Data(urlValue, serviceData[i].getIdentifier()));
            }
        }
        return result.toArray(new Data[0]);
    }

    protected Data[] outputReferenceForm(MessageContext msgContext, ServiceData[] serviceData) throws DataRetrievalException {
        OMElement epr = null;
        ArrayList<Data> result = new ArrayList<Data>();
        if (serviceData != null) {
            for (int i = 0; i < serviceData.length; ++i) {
                epr = serviceData[i].getEndpointReference();
                if (epr == null) continue;
                result.add(new Data(epr, serviceData[i].getIdentifier()));
            }
        }
        return result.toArray(new Data[0]);
    }

    protected void setServiceData(ServiceData[] inServiceData) {
        this.dataList = inServiceData;
    }

    protected OutputForm getOutputForm() {
        return this.outputform;
    }
}

