% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CmatStarGpois.R
\name{CmatStarGpois}
\alias{CmatStarGpois}
\title{Computes Intermediate Correlation Matrix}
\usage{
CmatStarGpois(corMat, theta.vec, lambda.vec, verbose = TRUE)
}
\arguments{
\item{corMat}{target correlation matrix.}

\item{theta.vec}{rate parameters in the generalized Poisson distribution. It is assumed that the
length of the vector is at least two, and each value has to be a positive number.}

\item{lambda.vec}{dispersion parameters in the generalized Poisson distribution. It is assumed that the length
of the vector is at least two. All lambda values have to be less than 1.
For lambda < 0, lambda must be greater than or equal to -theta/4.}

\item{verbose}{logical variable that determines whether to display the traces. Default is set to TRUE.}
}
\value{
intermediate correlation matrix.
}
\description{
\code{CmatStarGpois} computes an intermediate correlation matrix that will be used to obtain
the target correlation matrix using the inverse CDF transformation method in \code{GenMVGpois}.
If the intermediate correlation martrix is not positive definite, the nearest positive definite
matrix is used.
}
\examples{
\donttest{
 lambda.vec = c(-0.2, 0.2, -0.3)
 theta.vec = c(1, 3, 4)
 M = c(0.352, 0.265, 0.342)
 N = diag(3)
 N[lower.tri(N)] = M
 TV = N + t(N)
 diag(TV) = 1
 cstar = CmatStarGpois(TV, theta.vec, lambda.vec, verbose = TRUE)
 cstar}
}
\references{
Yahav, I. and Shmueli, G. (2012). On generating multivariate Poisson data in management science applications.
 \emph{Applied Stochastic Models in Business and Industry}, \bold{28(1)}, 91-102.
}
