% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{FIINT}
\alias{FIINT}
\title{Fully Indirect-INT}
\usage{
FIINT(y, G, X, S, k = 3/8)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Snp by obs genotype matrix.}

\item{X}{Obs by feature covariate matrix.}

\item{S}{Obs by feature structure matrix.}

\item{k}{Offset applied during rank-normalization. See
\code{\link{rankNormal}}.}
}
\value{
A numeric vector of p-values assessing the null hypothesis of no 
  genotypic effect. P-values are estimated using the Wald statistic, and 
  correspond to the rows of G.
}
\description{
Two-stage regression procedure. In the first stage, phenotype is regressed on 
covariates and adjustments for population structure to obtain residuals. In 
the second stage, INT-transformed residuals are regressed on genotype.
}
\details{
Note that, in simulations, FIINT did not consistently provide valid
inference. For a similar approach that did control the type I error, see
\code{\link{PIINT}}.
}
\examples{
# FIINT against normal phenotype 
p = RNOmni::FIINT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
