#' Simulated Genotypes
#' 
#' Simulated genotypes for 1000 subjects (columns) at 1000 loci (rows).
#' Genotypes were simulated with use of hapgen2, and are based on the haplotype
#' structure of human chromosome one in the CEU population of the 1000 Genomes
#' Project.
#' @format A double matrix with 1000 rows and 1000 columns.
#' \describe{ 
#'    \item{s1-s1000}{Each column corresponds to genotype at 1000 loci (rows) for a single subject.}
#' }
"G"

#' Population Structure Adjustments
#' 
#' First two principal components of the genetic relatedness matrix. Note that
#' principal components were calculated using genotype at more loci than are
#' provided in the example data set.
#' @format A numeric matrix with 1000 rows and 2 columns.
#' \describe{
#'    \item{pc1}{The first principal component.}
#'    \item{pc2}{The second principal component.}
#' }
"S"

#' Simulated Covariates
#' 
#' Age and sex simulated for 1000 subjects. Age was drawn from a gamma
#' distribution with mean 50 and variance 10. Sex was drawn from a Bernoulli
#' distribuiton with expectation 1/2. 
#' @format A numeric matrix with 1000 rows and 2 columns.
#' \describe{
#'    \item{Age}{Age.}
#'    \item{Sex}{Sex.}
#' }
"X"

#' Simulated Phenotypes
#' 
#' Two independent phenotypes simulated under the null hypothesis of no 
#' genotypic effect. A subject specific mean was calculated based on
#' age, sex, pc1, and pc2. The normal phenotype was generated by adding N(0,1)
#' deviates to the subject means. The T3 phenotype was generated by adding \eqn{t_{3}/sqrt{3}} deviates
#' to the subject means.
#' @format A numeric matrix with 1000 rows and 2 columns.
#' \describe{
#'    \item{YN}{Normal phenotype.}
#'    \item{YT3}{T3 phenotype.}
#' }
"Y"
