% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nexml_validate.R
\name{nexml_validate}
\alias{nexml_validate}
\title{validate nexml using the online validator tool}
\usage{
nexml_validate(file, schema = "http://www.nexml.org/2009/nexml.xsd")
}
\arguments{
\item{file}{path to the nexml file to validate}

\item{schema}{URL of schema (for fallback method only, set by default).}
}
\value{
TRUE if the file is valid, FALSE or error message otherwise
}
\description{
validate nexml using the online validator tool
}
\details{
Requires an internet connection.  see http://www.nexml.org/nexml/phylows/validator for more information in debugging invalid files
}
\examples{
\dontrun{
data(bird.orders)
birds <- nexml_write(bird.orders, "birds_orders.xml")
nexml_validate("bird_orders.xml")
unlink("bird_orders.xml") # delete file to clean up
}
}

