% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{get_metadata}
\usage{
get_metadata(nexml, level = "nexml")
}
\arguments{
\item{nexml}{a nexml object}

\item{level}{the name of the level of element desired, see details}
}
\value{
the requested metadata as a data.frame. Additional columns
indicate the parent element of the return value.
}
\description{
get_metadata
}
\details{
'level' should be either the name of a child element of a NeXML document 
(e.g. "otu", "characters"), or a path to the desired element, e.g. 'trees/tree'
will return the metadata for all phylogenies in all trees blocks.
}
\examples{
\dontrun{
comp_analysis <- system.file("examples", "primates.xml", package="RNeXML")
nex <- nexml_read(comp_analysis)
get_metadata(nex)
get_metadata(nex, "otus/otu")
}
}
