% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trees.R
\name{get_trees}
\alias{get_trees}
\title{extract a phylogenetic tree from the nexml}
\usage{
get_trees(nexml)
}
\arguments{
\item{nexml}{a representation of the nexml object from
which the data is to be retrieved}
}
\value{
an ape::phylo tree, if only one tree is represented.
 Otherwise returns a list of lists of multiphylo trees.
 To consistently receive the list of lists format (preserving 
 the hierarchical nature of the nexml), use \code{\link{get_trees_list}} instead.
}
\description{
extract a phylogenetic tree from the nexml
}
\examples{
comp_analysis <- system.file("examples", "comp_analysis.xml", package="RNeXML")
nex <- nexml_read(comp_analysis)
get_trees(nex)
}
\seealso{
\code{\link{get_trees}} \code{\link{get_flat_trees}} \code{\link{get_item}}
}
