% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexml_methods.R
\docType{methods}
\name{summary,nexml-method}
\alias{summary,nexml-method}
\alias{summary.nexml}
\title{Summary method for nexml objects}
\usage{
\S4method{summary}{nexml}(object)
}
\arguments{
\item{object}{the \link[=nexml-class]{nexml} object}
}
\value{
A list with the following elements:
\itemize{
\item \code{nblocks} the number of trees, otus, and characters blocks
\item \code{ncharacters} the number of characters in each characters block
\item \code{nstates} summary statistics of the number of character states per state set
defined for each characters block
\item \code{nnonstdstatedefs} the number of polymorphic and uncertain states defined
for each character block
\item \code{nmatrixrows} the number of rows in the matrix for each character block
\item \code{ntrees} the number of trees contained in each trees block
\item \code{notus} the number of OTUs defined in each OTUs block
\item \code{nmeta} a list of the number of the number of metadata annotations at
several levels, specifically:
\itemize{
\item \code{nexml} at the top (nexml) level
\item \code{otu} at the OTU level, for each OTUs block
\item \code{char} at the character level, for each characters block
\item \code{state} at the character state level, for each characters block
}
}
}
\description{
Generates a list of various counts of the major elements that comprise a
\link[=nexml-class]{nexml} object, such as number of different kinds of blocks,
characters, states, OTUs (taxa), etc.
}
\details{
The \link[methods:show]{show} method uses this summary for pretty-printing a
summary of the NeXML object, but it can be used on its own as well, in
particular for quick inspection of key properties of a NeXML file.
}
\examples{
nex <- nexml_read(system.file("examples", "comp_analysis.xml", package = "RNeXML"))
s <- summary(nex)
# number of major blocks:
s$nblocks

# each characters block defines 1 character:
s$ncharacters

# summary stats of states per character (for morphological matrices there is
# typically one state set per character)
s$nstates # note that first block is of continuous type, so no stats there

# pretty-printed summary:
nex # this is the same as show(nex)
}
