% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxize_nexml.R
\name{taxize_nexml}
\alias{taxize_nexml}
\title{taxize nexml}
\usage{
taxize_nexml(
  nexml,
  type = c("ncbi", "itis", "col", "tpl", "gbif", "wd"),
  warnings = TRUE,
  ...
)
}
\arguments{
\item{nexml}{a nexml object}

\item{type}{the name of the identifier to use}

\item{warnings}{should we show warning messages if no match can be found?}

\item{...}{additional arguments to \verb{[taxadb::get_ids()]}}
}
\description{
Check taxonomic names against the specified service and
add appropriate semantic metadata to the nexml OTU unit
containing the corresponding identifier.
}
\examples{
\dontrun{
data(bird.orders)
birds <- add_trees(bird.orders)
birds <- taxize_nexml(birds, "NCBI")
}
}
