% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getSingleNode.R
\name{getSingleNode}
\alias{getSingleNode}
\title{Retrieve Nodes with Cypher Queries}
\usage{
getSingleNode(graph, query, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{query}{A character string.}

\item{...}{Parameters to pass to the query in the form key = value, if applicable.}
}
\value{
A node object.
}
\description{
Deprecated. Use \code{\link{cypherToList}}. Retrieve a single node from the graph with a Cypher query.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

createNode(graph, "Person", name = "Alice", age = 23)
createNode(graph, "Person", name = "Bob", age = 22)
createNode(graph, "Person", name = "Charles", age = 25)

query = "MATCH (p:Person)
		 WITH p
		 ORDER BY p.age DESC
		 RETURN p
		 LIMIT 1"

getSingleNode(graph, query)

query = "MATCH (p:Person {name:{name}})
         RETURN p"

getSingleNode(graph, query, name = "Alice")
}
}
\seealso{
\code{\link{getNodes}}
}

