% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm_functions.r
\name{term.day.dist}
\alias{term.day.dist}
\title{Calculate statistics for term occurence across days}
\usage{
term.day.dist(dtm, meta = NULL, date.var = "date")
}
\arguments{
\item{dtm}{A quanteda \link[quanteda]{dfm}. Alternatively, a DocumentTermMatrix from the tm package can be used, but then the meta parameter needs to be specified manually}

\item{meta}{If dtm is a quanteda dfm, docvars(meta) is used by default (meta is NULL) to obtain the meta data. Otherwise, the meta data.frame has to be given by the user, with the rows of the meta data.frame matching the rows of the dtm (i.e. each row is a document)}

\item{date.var}{The name of the meta column specifying the document date. default is "date". The values should be of type POSIXlt or POSIXct}
}
\value{
A data.frame with statistics for each term.
\itemize{
 \item{freq:}{ The number of times a term occurred}
 \item{doc.freq:}{ The number of documents in which a term occured}
 \item{days.n:}{ The number of days on which a term occured}
 \item{days.pct:}{ The percentage of days on which a term occured}
 \item{days.entropy:}{ The entropy of the distribution of term frequency across days}
 \item{days.entropy.norm:}{ The normalized days.entropy, where 1 is a discrete uniform distribution}
}
}
\description{
Calculate statistics for term occurence across days
}
\examples{
tdd = term.day.dist(rnewsflow_dfm, date.var='date')
head(tdd)
tail(tdd)
}
