% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{dumpNifti}
\alias{dumpNifti}
\alias{print.niftiHeader}
\title{Dump the contents of an internal NIfTI-1 object}
\usage{
dumpNifti(image)

\method{print}{niftiHeader}(x, ...)
}
\arguments{
\item{image}{An image, in any acceptable form (see
\code{\link{retrieveNifti}}).}

\item{x}{A \code{"niftiHeader"} object.}

\item{...}{Ignored.}
}
\value{
For \code{dumpNifti}, a list of class \code{"niftiHeader"}, with
  named components corresponding to the elements in a raw NIfTI-1 file.
}
\description{
This function extracts the contents of an internal NIfTI-1 object into an R
list. No processing is done to the elements.
}
\examples{
dumpNifti(system.file("extdata", "example.nii.gz", package="RNifti"))

# Default header for a standard R array
dumpNifti(array(0L, dim=c(10,10)))

}
\references{
The NIfTI-1 standard (\url{http://www.nitrc.org/docman/view.php/26/64/nifti1.h}).
}
\author{
Jon Clayden <code@clayden.org>
}
