% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gainstable.R
\name{gainstable.default}
\alias{gainstable.default}
\title{Gains Table for Binary Classifier}
\usage{
\method{gainstable}{default}(score, class, negref = NULL, ngroup = 10, breaks = NULL, ... = NULL)
}
\arguments{
\item{score}{An numeric array of diagnostic score. Same as in
\code{\link{rocit}}.}

\item{class}{An array of equal length of score,
containing the class of the observations. Same as in \code{\link{rocit}}.}

\item{negref}{The reference value, same as the
\code{reference} in \code{\link{convertclass}}.
Depending on the class of \code{x},
it can be numeric or character type. If specified, this value
is converted to 0 and other is converted to 1. If NULL, reference is
set alphabetically. Same as in \code{\link{rocit}}.}

\item{ngroup}{Number of desired groups in gains table. Ignored if
\code{breaks} is specified.
See "Details".}

\item{breaks}{Percentiles (in percentage) at which observations
should be separated to
form groups. If specified, \code{ngroup} is ignored. See "Details".}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
A list of class \code{"gainstable"}. It has the following components:

\item{Bucket}{The serial number of buckets or groups.}
\item{Obs}{Number of observation in the group.}
\item{CObs}{Cumulative number of observations up to the group.}
\item{Depth}{Cumulative population depth up to the group.}
\item{Resp}{Number of (positive) responses in the group.}
\item{CResp}{Cumulative number of (positive) responses up to the group.}
\item{RespRate}{(Positive) response rate in the group.}
\item{CRespRate}{Cumulative (positive) response rate up to the group}
\item{CCapRate}{Cumulative overall capture rate of (positive) responses
up to the group.}
\item{Lift}{Lift index in the group. Calculated as
\eqn{GroupResponseRate / OverallResponseRate}.}
\item{CLift}{Cumulative lift index up to the group.}
}
\description{
Default S3 method to create gains table from a vector of
diagnostic score and the class of observations.
}
\details{
\code{gainstable} function creates gains table containing
\code{ngroup} number of groups or buckets. The algorithm first orders
the score variable with respect to score variable. In case of tie,
it class becomes the ordering variable, keeping the positive responses first.
The algorithm calculates the ending index in each bucket as
\eqn{round((length(score) / ngroup) * (1:ngroup))}. Each bucket should have
at least 5 observations.


      If buckets' end index are to be ended at desired level of
population, then \code{breaks} should be specified.
If specified, it overrides \code{ngroup} and \code{ngroup} is ignored.
\code{breaks} by default always includes 100. If whole number does not exist
at specified population, nearest integers are considered.
}
\note{
The algorithm is designed for complete cases. If NA(s) found in
either \code{score} or \code{class}, then removed.
}
\examples{
data("Loan")
class <- Loan$Status
score <- Loan$Score
# ----------------------------------------------------------------
gtable15 <- gainstable(score = score, class = class,
                       negref = "FP", ngroup = 15)
gtable_custom <- gainstable(score = score, class = class,
                            negref = "FP", breaks = seq(1,100,15))
# ----------------------------------------------------------------
print(gtable15)
print(gtable_custom)
# ----------------------------------------------------------------
plot(gtable15)
plot(gtable_custom)
plot(gtable_custom, type = 2)
plot(gtable_custom, type = 3)

}
\seealso{
\code{\link{gainstable.rocit}}, \code{\link{plot.gainstable}},
\code{\link{rocit}}
}
