% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurvival.R
\name{getsurvival}
\alias{getsurvival}
\title{Survival Probability}
\usage{
getsurvival(x, cutoff)
}
\arguments{
\item{x}{An object of class "density".}

\item{cutoff}{Value at which survival probability will be calculated.}
}
\value{
Survival probability.
}
\description{
Function \code{getsurvival} calculates survival probability
from an object of class "density" at specified value.
}
\details{
The survival function S, of a random variable \eqn{X} is defined by,
\deqn{S(X=x) = 1 - F(X=x)} where \eqn{F} is the cumulative density
function (CDF) of \eqn{X}.
}
\section{Comment}{

\code{getsurvival} is used internally in other function(s) of \pkg{ROCit}.
}

\examples{
data("Loan")
k <- density(Loan$Income)
# What portion have income over 100,000
getsurvival(k,100000)


}
