% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miplib.R
\name{miplib}
\alias{miplib}
\title{Access the Downloaded \code{MIPLIB}}
\usage{
miplib(x, folder = system.file("roi_op", package = "ROI.models.miplib"))
}
\arguments{
\item{x}{a character giving the names of the optimization problems
to be returned, if \code{x} is \code{"all"} all available problems
are returned, if \code{x} is the name of a single problem the
given problem is returned. If \code{x} is missing a listing 
of all available problems is returned. If \code{x} is \code{"metainfo"}
the meta information about the problems is returned.}

\item{folder}{the folder where the optimization problems are stored.}
}
\description{
Get one or more optimization problems, meta information or a listing
    of the available \code{MIPLIB 2010} problems.
}
\details{
The function \code{miplib} searches in the given folder for
    \code{.rds} files and returns them.
}
\examples{
\dontrun{
## list all available MIPLIB-2010 problems
miplib()
## get all miplib problems
miplib("all")
## get a single problem
miplib("rmine6")
## get the meta information
miplib("metainfo")
}
}
