
context("MILP")

## MILP - Example - 2
## min:  3 x + 1 y + 3 z
## s.t.
##      -1 x  +    y  +   z  <=  4
##               4 y  - 3 z  <=  2
##         x  -  3 y  + 2 z  <=  3
##     x, z \in Z_+
##     y >= 0
test_that("Example 1", {

    library( testthat )
    library( ROI )

    obj <- c(3, 1, 3)
    A <- rbind(c(-1,  2,  1),
               c( 0,  4, -3),
               c( 1, -3,  2))
    b <- c(4, 2, 3)

    x <- OP(objective = obj,
         constraints = L_constraint(L = A,
                                    dir = c("<=", "<=", "<="),
                                    rhs = b),
         types = c("I", "C", "I"),
         maximum = TRUE)

    for ( SOLVER in OP_applicable_solver(x) ) {
        cat("  ", SOLVER)
        opt <- ROI_solve(x, solver=SOLVER, control=list(eps=1e-12))
        check( opt$solution , c(5, 2.75, 3) )
        cat("\n")
    }  

} )
