% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.rmultivariate_normal.R
\name{rmultivariate_normal}
\alias{rmultivariate_normal}
\title{rmultivariate_normal}
\usage{
rmultivariate_normal(n, mean, cov)
}
\arguments{
\item{n}{[integer] numbers of samples drawn}

\item{mean}{[vector] mean of Normal law}

\item{cov}{[matrix] covariance matrix}
}
\value{
[matrix]
}
\description{
Generate sample from a multivariate normal distribution. The generator uses
a singular values decomposition to draw samples from a normal distribution
in the basis of the singular vector. Consequently, the covariance matrix
can be singular.
}
\examples{
mean = stats::runif( n = 2 , min = -5 , max = 5 )
cov  = ROOPSD::rspd_matrix(2)
X    = ROOPSD::rmultivariate_normal( 10000 , mean , cov )

}
