% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GetExperimentResults.R
\name{GetExperimentResults}
\alias{GetExperimentResults}
\title{Extract results of an experiment}
\usage{
GetExperimentResults(experiment.list)
}
\arguments{
\item{experiment.list}{list of experiment identifier.}
}
\value{
data frame with experiments results. A data frame representing every combination of variations and goals that have been defined for each experiment in list. For example, if there are three variations and two goals defined for an experiment, the response will contain six rows representing each variation_id and goal_id combination.
}
\description{
Query Optimizely API to extract top-level results experiment. Results returned are computed by Optimizely Stats Engine.
Metrics  for each experiment are listed for every combination of variations and goals defined for that experiment.
}
\examples{
\dontrun{
# Extract results
# Assign token before getting results
set_token('abcdefghihjklmnopqrs:54321')
results.df<-GetExperimentResults(c('123123','1234567'))
}
}
\seealso{
\code{\link{GetResults}}
}

