% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{filter_Ct}
\alias{filter_Ct}
\title{filter_Ct}
\usage{
filter_Ct(
  data,
  flag.Ct = "Undetermined",
  maxCt = 35,
  flag = c("Undetermined"),
  remove.Gene = c(""),
  remove.Sample = c(""),
  remove.Group = c("")
)
}
\arguments{
\item{data}{Object returned from read_Ct_long() or read_Ct_wide() function,
or data frame containing column named "Sample" with sample names, column named "Gene" with gene names,
column named "Ct" with raw Ct values, column named "Group" with group names.
Optionally, data frame can contain column named "Flag" with flag information (e.g. "Undetermined" and "OK"),
which will be used for filtering.}

\item{flag.Ct}{Character of a flag used for undetermined Ct values, default to "Undetermined".}

\item{maxCt}{Numeric, a maximum of Ct value allowed.}

\item{flag}{Character: flag used in Flag column for values which should be filtered out, default to "Undetermined".}

\item{remove.Gene}{Character: vector with names of genes to remove from data}

\item{remove.Sample}{Character: vector with names of samples to remove from data}

\item{remove.Group}{Character: vector with names of groups to remove from data}
}
\value{
Data frame with filtered data.
}
\description{
This function filters Ct data according to the used filtering criteria (see parameters).
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))

dim(data.Ct)
dim(data.CtF)

}
