% $Id: ImpliedVolatility.Rd,v 1.1 2002/02/26 03:48:53 edd Exp $
\name{ImpliedVolatility}
\alias{ImpliedVolatility}
\alias{print.ImpliedVolatility}
\alias{summary.ImpliedVolatility}
\title{Base class for option-price implied volatility evalution}
\description{
  This class forms the basis from which the more specific classes are
  derived. }
\usage{
\method{print}{ImpliedVolatility}
\method{summary}{ImpliedVolatility}
}
\arguments{
  \item{AnImpliedVol}{Any option-price implied volatility object derived
    from this base class} 
}
\value{
  None, but side effects of displaying content.
}
\details{
  Please see any decent Finance textbook for background reading, and the
  \code{QuantLib} documentation for details on the \code{QuantLib}
  implementation.  
}
\references{\url{http://quantlib.org} for details on \code{QuantLib}.}
\author{Dirk Eddelbuettel \email{edd@debian.org} for the \R interface;
  the QuantLib Group for \code{QuantLib}}
\note{The interface might change in future release as \code{QuantLib}
  stabilises its own API.}

\seealso{\code{\link{AmericanOptionImpliedVolatility}},
  \code{\link{EuropeanOptionImpliedVolatility}},
  \code{\link{AmericanOption}},\code{\link{EuropeanOption}},
  \code{\link{BinaryOption}}}

\examples{
impVol<-EuropeanOptionImpliedVolatility("call", value=11.10, strike=100, volatility=0.4, 100, 0.01, 0.03, 0.5)
print(impVol)
summary(impVol)
}
\keyword{misc}

