#' @title Example dataset
#' @description Geometric morphometrics shape data regarding felids' mandible
#'   and phylogentic tree (\cite{Piras et al., 2018}).
#' @name DataFelids
#' @format A list containing: \describe{\item{\strong{$treefel}}{Phylogenetic tree of felids}.
#' \item{\strong{$landfel}}{list of 2D landmark configuration for each species of the tree}.
#'  \item{\strong{$PCscoresfel}}{A data.frame containing 83 shape variables for felids' mandible}.
#'  \item{\strong{$statefel}}{sabertooth - not sabertooth ecomorph categorization for each species}.
#'   }
#' @docType data
#' @author Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
#'   Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
#'   Carotenuto
#' @keywords RRphylo
#' @usage data(DataFelids)
#' @references Piras, P., Silvestro, D., Carotenuto, F., Castiglione, S.,
#'   Kotsakis, A., Maiorino, L., Melchionna, M.,Mondanaro, A., Sansalone, G.,
#'   Serio, C., Vero, V. A., & Raia, P. (2018). Evolution of the sabertooth
#'   mandible: A deadly ecomorphological specialization. \emph{Palaeogeography,
#'   Palaeoclimatology, Palaeoecology}, 496, 166-174.
NULL
