% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compRates.R
\name{compRates}
\alias{compRates}
\title{Comparing average absolute rates between clades}
\usage{
compRates(RR,node, nrep = 1000, cov = NULL)
}
\arguments{
\item{RR}{an object fitted by the function \code{\link{RRphylo}}.}

\item{node}{the most recent common ancestors of clades to be tested. The
nodes must be identified on the dicothomized version of the original tree
returned by \code{\link{RRphylo}}. Pairwise comparison between all clades is
performed.}

\item{nrep}{the number of simulations to be performed for the rate shift
test, by default \code{nrep} is set at 1000.}

\item{cov}{the covariate vector to be indicated if its effect on rate values
must be accounted for. Contrary to \code{\link{RRphylo}}, \code{cov} needs to be
as long as the number of tips of the tree.}
}
\value{
For each node pair, the function returns the average absolute rate
  difference (computed as the difference between the average absolute rate
  over all branches subtended by the nodes) and related significance level.
  Probabilities are derived by contrasting the rate differences to simulated
  ones derived by shuffling the rates across the tree branches for a number
  of replicates specified by the argument \code{nrep}. Note that the p-values
  refer to the number of times the real differences are larger
  (p-value>=0.975) or smaller (p-value<=0.025) than the simulated ones,
  divided by the number of simulations, hence the test should be considered
  as two-tailed.
  The output always has an attribute "Call" which returns an unevaluated call to the function.
}
\description{
The function \code{compRates} is an adaptation of
  \code{\link{search.shift}} which performs pairwise comparison of average
  absolute rates between clades via bootstrap.
}
\examples{
\dontrun{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino
DataOrnithodirans$statedino->statedino
cc<- 2/parallel::detectCores()

RRphylo(tree=treedino,y=massdino,clus=cc)->dinoRates
compRates(RR=dinoRates,node=c(696,746))->cr1
compRates(RR=dinoRates,node=c(696,746),cov=massdino)->cr2
    }
}
\seealso{
\href{../doc/search.shift.html}{\code{search.shift} vignette}
}
\author{
Silvia Castiglione, Giorgia Girardi
}
