/*
 * Decompiled with CFR 0.152.
 */
package org.act.sol;

import java.io.IOException;
import java.util.List;
import org.act.cat.CatInput;
import org.act.cat.ExposureControlType;
import org.act.mip.SolverConfig;
import org.act.mip.SolverInputSingleItem;
import org.act.mip.SolverInputSinglePassage;
import org.act.mip.SolverOutput;
import org.act.sol.TestAssembly;
import org.act.testdef.ItemRealTimeData;
import org.act.testdef.PassageRealTimeData;
import org.act.testdef.TestConfig;

public final class ShadowTestRun {
    private static final double BIG_M_DEFAULT = 10.0;
    private final TestConfig testConfig;
    private final SolverConfig solverConfig;
    private TestAssembly testAssembly;

    public ShadowTestRun(CatInput catInput) throws IOException {
        this.testConfig = catInput.getTestConfig();
        this.solverConfig = catInput.getCatConfig().solverConfig();
        this.testAssembly = new TestAssembly(this.testConfig, this.solverConfig);
    }

    public SolverOutput runShadowTestAssembly(int stageIndex, List<SolverInputSingleItem> itemInput, List<SolverInputSinglePassage> passageInput, double theta, double bigM, ExposureControlType exposureType) throws IOException {
        int[] preSolutions = new int[itemInput.size()];
        int count = 0;
        for (SolverInputSingleItem singleItemInput : itemInput) {
            int itemIdex = this.testAssembly.getItemIdList().indexOf(singleItemInput.getItemIdentifier());
            ItemRealTimeData itemRealTimeData = this.testAssembly.getItemRealTimeDataList().get(itemIdex);
            if (singleItemInput.isAdministered() && !itemRealTimeData.isAdmined) {
                this.testAssembly.getAdminedItemList().add(singleItemInput.getItemIdentifier());
                itemRealTimeData.isAdmined = true;
            }
            itemRealTimeData.info = singleItemInput.getInformation();
            itemRealTimeData.isEligible = singleItemInput.isEligible();
            itemRealTimeData.isEligibleHard = singleItemInput.isEligibleHard();
            preSolutions[count] = singleItemInput.isSelected() ? 1 : 0;
            ++count;
        }
        if (passageInput != null) {
            for (SolverInputSinglePassage singlePassageInput : passageInput) {
                int passageIndex = this.testAssembly.getPassageIdList().indexOf(singlePassageInput.getPassageIdentifier());
                PassageRealTimeData passageRealTimeData = this.testAssembly.getPassageRealTimeDataList().get(passageIndex);
                passageRealTimeData.isEligible = singlePassageInput.isEligible();
            }
        }
        SolverOutput optResult = this.testAssembly.assembleTest(stageIndex, theta, bigM, exposureType);
        return optResult;
    }

    public SolverOutput runShadowTestAssembly(int stageIndex, List<SolverInputSingleItem> itemInput, double theta) throws IOException {
        return this.runShadowTestAssembly(stageIndex, itemInput, null, theta, 10.0, ExposureControlType.NONE);
    }

    public TestAssembly getTestAssembly() {
        return this.testAssembly;
    }
}

