package org.act.cat;

import java.util.List;

/**
 * An effectively immutable container for output data generated by the
 * {@link CatEngine}.
 */
public interface CatOutput {
    /**
     * Returns the indicator of whether the test is complete or not.
     *
     * @return true if the test is complete, false otherwise
     */
    boolean getTestComplete();

    /**
     * Gets an ordered list of the item item identifiers of the next items in the
     * shadow test.
     *
     * @return an ordered list of the item item identifiers of the next items in the
     *         shadow test, or an empty list if the test is complete.
     */
    CatItemsToAdminister getItemsToAdminister();

    /**
     * Returns the value of the ability estimate.
     *
     * @return the ability estimate {@code ThetaEst}
     */
    ThetaEst getThetaEst();

    /**
     * Returns the item/passage eligibility data.
     *
     * @return the instance of {@link PassageOrItemEligibilityAtThetaRange} that
     *         represents item/passage eligibility data
     */
    PassageOrItemEligibilityAtThetaRange getPassageOrItemEligibilityAtThetaRange();

    /**
     * Returns the shadow test.
     *
     * @return the array of {@code String} characters that represent the shadow test
     */
    List<String> getShadowTest();

    /**
     * Returns the CAT engine runtime.
     *
     * @return the CAT engine runtime in seconds
     */
    double getCatEngineTime();

    /**
     * Returns the MIP solver runtime.
     *
     * @return the MIP solver run time in seconds
     */
    double getSolverTime();

}
