/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

import org.act.cat.CatFunctions;
import org.act.cat.ItemSelectionMethod;
import org.apache.commons.math3.linear.RealMatrix;

public class MaxFisherInformationMethod
implements ItemSelectionMethod {
    private RealMatrix itemPar;
    private double thetaEst;

    public MaxFisherInformationMethod(RealMatrix itemPar, double thetaEst) {
        this.itemPar = itemPar;
        this.thetaEst = thetaEst;
    }

    @Override
    public double[] getSelectionCriteria() {
        int parNum = this.itemPar.getRowDimension();
        double[] fisherInformation = new double[parNum];
        for (int i = 0; i < parNum; ++i) {
            double a = this.itemPar.getEntry(i, 0);
            double b = this.itemPar.getEntry(i, 1);
            double c = this.itemPar.getEntry(i, 2);
            double d = this.itemPar.getEntry(i, 3);
            double p = CatFunctions.getProb3PL(a, b, c, d, this.thetaEst);
            double q = 1.0 - p;
            fisherInformation[i] = d * d * a * a * (q / p) * ((p - c) / (1.0 - c)) * ((p - c) / (1.0 - c));
        }
        return fisherInformation;
    }

    @Override
    public ItemSelectionMethod.SUPPORTED_METHODS getMethodType() {
        return ItemSelectionMethod.SUPPORTED_METHODS.MAX_FISHER_INFO;
    }
}

