\name{denormalizeData}
\alias{denormalizeData}
\title{Revert data normalization}
\usage{denormalizeData(x, normParams)
}
\description{Column-wise normalization of the input matrix is reverted, using the given parameters.}
\details{The input matrix is column-wise denormalized using the parameters given by \code{normParams}. 
E.g., if \code{normParams} contains mean and sd for every column, the values are multiplied 
by sd and the mean is added}
\value{column-wise denormalized input}
\seealso{\code{\link{normalizeData}}, \code{\link{getNormParameters}}}
\arguments{\item{x}{input data}
\item{normParams}{the parameters generated by an earlier call to \code{\link{normalizeData}} that will be used for reverting normalization}
}
\examples{data(iris)
values <- normalizeData(iris[,1:4])
denormalizeData(values, getNormParameters(values))}

